package com.mmc.pms.model.mall;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @Author LW
 * @date 2023/7/24 20:16
 * 概要：
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class GoodsSpecVO {
    @ApiModelProperty(value = "id")
    private Integer id;
    @ApiModelProperty(value = "商品id")
    private Long mallGoodsId;
    @ApiModelProperty(value = "规格名称", example = "规格名称", required = true)
    private String specName;
    @ApiModelProperty(value = "选择方式 ：0单选，1多选", example = "1", required = true)
    private Integer chooseType;
    @ApiModelProperty(value = "是否必选 ： 0 非必选 1 必选", example = "0", required = true)
    private Integer must;
    @ApiModelProperty(value = "单位id", example = "1", required = true)
    private Integer skuUnitId;
    @ApiModelProperty(value = "规格值信息", required = true)
    private List<GoodsSpecValuesVO> goodsSpecValuesList;
}
