package com.mmc.pms.entity.mall;

import com.mmc.pms.model.mall.GoodsSpecVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * (GoodsSpecDO)实体类
 *
 * @author makejava
 * @since 2023-07-24 21:16:41
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class GoodsSpecDO implements Serializable {
    private static final long serialVersionUID = 381669128695968475L;

    private Integer id;
    /**
     * 商品id
     */
    private Long mallGoodsId;
    /**
     * 规格名称
     */
    private String specName;
    /**
     * 0单选，1多选
     */
    private Integer chooseType;
    /**
     * 0 非必选 1 必选
     */
    private Integer must;
    /**
     * 单位id
     */
    private Integer skuUnitId;

    private Date createTime;

    private Date updateTime;

    public GoodsSpecDO(GoodsSpecVO goodsSpecVO) {
        this.id = goodsSpecVO.getId();
        this.mallGoodsId = goodsSpecVO.getMallGoodsId();
        this.specName = goodsSpecVO.getSpecName();
        this.chooseType = goodsSpecVO.getChooseType();
        this.must = goodsSpecVO.getMust();
        this.skuUnitId = goodsSpecVO.getSkuUnitId();
    }

    public GoodsSpecVO buildGoodsSpecVO() {
        return GoodsSpecVO.builder().id(id).mallGoodsId(mallGoodsId).specName(specName)
                .chooseType(chooseType).must(must).skuUnitId(skuUnitId).build();
    }

}

