package com.mmc.pms.dao.mall;

import com.mmc.pms.entity.SkuUnitDO;
import com.mmc.pms.entity.mall.GoodsSpecDO;
import com.mmc.pms.entity.mall.GoodsSpecValuesDO;
import com.mmc.pms.entity.mall.MallGoodsDO;
import com.mmc.pms.entity.mall.MallGoodsResourcesDO;
import com.mmc.pms.model.mall.MallGoodsVO;
import com.mmc.pms.model.sale.qo.MallGoodsQO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @Author LW
 * @date 2023/7/24 17:38 概要：
 */
@Mapper
public interface MallGoodsDao {
    int countMallGoodsByName(@Param("mallGoodsVO") MallGoodsVO mallGoodsVO, @Param("userAccountId") Integer userAccountId);

    int countMallGoods(Integer userAccountId);

    void insertMallGoodsBaseInfo(MallGoodsDO mallGoodsDO);

    void insertGoodsSpec(GoodsSpecDO goodsSpecDO);

    void batchInsertSpecValues(List<GoodsSpecValuesDO> goodsSpecValuesList);

    void batchInsertMallGoodsResources(List<MallGoodsResourcesDO> mallGoodsResourcesList);

    MallGoodsDO getMallGoodsBaseInfo(Long id);

    List<MallGoodsResourcesDO> getMallGoodsResources(Long id);

    List<GoodsSpecDO> getMallGoodsSpec(Long id);

    List<GoodsSpecValuesDO> getMallGoodsSpecValues(List<Integer> ids);

    void updateMallGoods(@Param("mallGoodsDO") MallGoodsDO mallGoodsDO);

    void deleteMallGoodsResources(Long id);

    void deleteGoodsSpec(List<Integer> deleteSpec);

    void updateGoodsSpec(GoodsSpecDO goodsSpecDO);

    void deleteGoodsSpecValues(List<Integer> deleteSpecValueId);

    void updateGoodsSpecValue(GoodsSpecValuesDO goodsSpecValuesDO);

    List<SkuUnitDO> getSkuUnit();

    int countListMallGoods(MallGoodsQO param);

    List<MallGoodsDO> listMallGoods(MallGoodsQO param);

    int updateMallGoodsSort(Long id, Integer sort);

    void updateMallGoodsByShelf(Long id, Integer status);

    void removeMallGoods(Long id);
}
