package com.mmc.pms.service.impl;

import com.mmc.pms.auth.dto.UserAccountSimpleDTO;
import com.mmc.pms.common.ResultBody;
import com.mmc.pms.common.ResultEnum;
import com.mmc.pms.constant.TokenConstant;
import com.mmc.pms.dao.CategoriesDao;
import com.mmc.pms.dao.GoodsInfoDao;
import com.mmc.pms.dao.ProductDao;
import com.mmc.pms.dao.WebDeviceDao;
import com.mmc.pms.entity.*;
import com.mmc.pms.feign.UserAppApi;
import com.mmc.pms.model.lease.dto.*;
import com.mmc.pms.model.lease.vo.LeaseVo;
import com.mmc.pms.model.other.dto.AdDTO;
import com.mmc.pms.model.other.dto.DistrictInfoDTO;
import com.mmc.pms.model.other.dto.ModelDTO;
import com.mmc.pms.model.qo.WareInfoQO;
import com.mmc.pms.model.sale.dto.MallGoodsDetailDTO;
import com.mmc.pms.model.sale.dto.SkuInfoDTO;
import com.mmc.pms.model.sale.vo.ProductSpecCPQVO;
import com.mmc.pms.model.sale.vo.SpecPriceVO;
import com.mmc.pms.page.PageResult;
import com.mmc.pms.service.WebDeviceService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Author small @Date 2023/5/15 14:32 @Version 1.0
 */
@Service
public class WebDeviceServiceImpl implements WebDeviceService {

  @Autowired WebDeviceDao webDeviceDao;

  @Autowired UserAppApi userAppApi;

  @Autowired ProductDao productDao;

  @Autowired GoodsInfoDao goodsInfoDao;

  @Autowired GoodsInfoServiceImpl goodsInfoService;

  @Autowired private CategoriesDao categoriesDao;

  @Override
  public ResultBody listSecondDistrict() {
    List<DistrictDO> list = webDeviceDao.listSecondDistrict();
    List<DistrictInfoDTO> dtoList =
        list.stream().map(DistrictDO::builderDistrictInfoDTO).collect(Collectors.toList());
    return ResultBody.success(dtoList);
  }

  @Override
  public ResultBody category() {
    List<DeviceCategory> category = webDeviceDao.category();
    List<DeviceCategoryDTO> collect =
        category.stream()
            .map(
                t -> {
                  return t.deviceCategory();
                })
            .collect(Collectors.toList());
    return ResultBody.success(collect);
  }

  @Override
  public ResultBody brand() {
    List<Brand> brand = webDeviceDao.brand();
    List<BrandDTO> collect =
        brand.stream()
            .map(
                t -> {
                  return t.brandDTO();
                })
            .collect(Collectors.toList());
    return ResultBody.success(collect);
  }

  @Override
  public ResultBody deviceBrand() {
    List<Brand> brand = webDeviceDao.deviceBrand();
    List<BrandDTO> collect =
        brand.stream()
            .map(
                t -> {
                  return t.brandDTO();
                })
            .collect(Collectors.toList());
    return ResultBody.success(collect);
  }

  @Override
  public ResultBody model() {
    List<Model> model = webDeviceDao.model();
    List<ModelDTO> collect =
        model.stream()
            .map(
                t -> {
                  return t.modelDTO();
                })
            .collect(Collectors.toList());
    return ResultBody.success(collect);
  }

  @Override
  public ResultBody deviceModel() {
    List<Model> model = webDeviceDao.deviceModel();
    List<ModelDTO> collect =
        model.stream()
            .map(
                t -> {
                  return t.modelDTO();
                })
            .collect(Collectors.toList());
    return ResultBody.success(collect);
  }

  @Override
  public ResultBody deviceList(
      Integer districtId, Integer categoryId, Integer brandId, Integer modelId) {
    List<DeviceListDO> deviceList =
        webDeviceDao.deviceList(districtId, categoryId, brandId, modelId);
    List<DeviceListDTO> collect =
        deviceList.stream()
            .map(
                t -> {
                  return t.deviceListDTO();
                })
            .collect(Collectors.toList());
    return ResultBody.success(collect);
  }

  @Override
  public ResultBody update(LeaseVo param) {
    InventoryDO inventory = webDeviceDao.findInventory(param.getInventoryId());
    Integer residueCount = inventory.getResidueCount();
    Integer count = residueCount - param.getInventoryUsage();
    param.setInventoryUsage(count);
    int update = webDeviceDao.update(param);
    return ResultBody.success(update);
  }

  @Override
  public ResultBody detail(Integer id) {
    List<WareInfoDO> list = webDeviceDao.detail(id);
    List<WareInfoItemDTO> pageList =
        list.stream()
            .map(
                d -> {
                  return d.buildWareInfoItemDTO();
                })
            .collect(Collectors.toList());
    return ResultBody.success(pageList);
  }

  @Override
  public ResultBody listWareInfoPage(
      WareInfoQO param, HttpServletRequest request, Integer userAccountId) {
    List<Integer> userIds = null;
    if (param.getProvinceId() != null) {
      userIds =
          userAppApi.feignListUserAccountIds(
              param.getProvinceId(),
              null,
              null,
              StringUtils.isBlank(request.getHeader(TokenConstant.TOKEN))
                  ? null
                  : request.getHeader(TokenConstant.TOKEN));
      if (userIds == null || userIds.size() == 0) {
        userIds = Collections.singletonList(-1);
      }
    }
    int count =
        webDeviceDao.countListWareInfoPage(
            param.getCategoryId(), userIds, param.getType(), param.getGoodsName());
    if (count == 0) {
      return ResultBody.success(
          PageResult.buildPage(param.getPageNo(), param.getPageSize(), count));
    }
    int pageNo = param.getPageNo();
    param.buildCurrentPage();
    List<GoodsInfo> list =
        webDeviceDao.listWareInfoPage(param, userIds, param.getType(), param.getGoodsName());
    List<LeaseGoodsInfoDTO> pageList =
        list.stream().map(GoodsInfo::buildLeaseGoodsInfoDTO).collect(Collectors.toList());
    if (StringUtils.isBlank(request.getHeader(TokenConstant.TOKEN))) {
      return ResultBody.success(PageResult.buildPage(pageNo, param.getPageSize(), count, pageList));
    }

    UserAccountSimpleDTO userAccountSimpleDTO =
        userAppApi.feignGetUserSimpleInfo(userAccountId, request.getHeader(TokenConstant.TOKEN));
    if (userAccountSimpleDTO == null) {
      return ResultBody.error(ResultEnum.INTERNAL_SERVER_ERROR);
    }
    if (userAccountSimpleDTO.getCooperationTagId() == null) {
      return ResultBody.success(PageResult.buildPage(pageNo, param.getPageSize(), count, pageList));
    }
    List<Integer> goodsId =
        pageList.stream().map(LeaseGoodsInfoDTO::getId).collect(Collectors.toList());
    List<MallProdSkuInfoSpecDO> mallProSkuInfoSpec = goodsInfoDao.listMallprodSpecById(goodsId);
    Map<Integer, MallProdSkuInfoSpecDO> specMap =
        mallProSkuInfoSpec.stream()
            .collect(
                Collectors.toMap(MallProdSkuInfoSpecDO::getGoodsInfoId, d -> d, (k1, k2) -> k1));
    pageList.stream()
        .peek(
            d -> {
              MallProdSkuInfoSpecDO mallProdSkuInfoSpecDO = specMap.get(d.getId());
              d.setPrice(mallProdSkuInfoSpecDO.getPrice());
            })
        .collect(Collectors.toList());
    return ResultBody.success(PageResult.buildPage(pageNo, param.getPageSize(), count, pageList));
  }

  @Override
  public ResultBody getLeaseGoodsDetail(
      Integer goodsInfoId, Integer userAccountId, HttpServletRequest request, Integer type) {
    int count = goodsInfoDao.countGoodsInfoById(goodsInfoId);
    if (count <= 0) {
      return ResultBody.error(ResultEnum.GOODS_NOT_EXIST_OR_ALREADY_DOWN_SHELF);
    }
    // 初始化商品返回信息的对象
    ResultBody goodsInfoDetail = goodsInfoService.getGoodsInfoDetail(goodsInfoId, type, 0);
    MallGoodsDetailDTO result = (MallGoodsDetailDTO) goodsInfoDetail.getResult();
    return ResultBody.success(result);
  }

  @Override
  public WareInfoDTO getWareInfoById(Integer id) {
    WareInfoDO wareInfoDO = webDeviceDao.getWareInfoById(id);
    WareDetailDO wareDetailDO = webDeviceDao.getWareDetailById(id);
    if (wareInfoDO != null) {
      wareInfoDO.setWareDetailContent(wareDetailDO.getContent());
    }
    return wareInfoDO == null ? null : wareInfoDO.buildWareInfoDTO();
  }

  @Override
  public ResultBody getPageHomeCategories(Integer type) {
    if (!type.equals(5) && !type.equals(6)) {
      List<DirectoryDO> directoryList = categoriesDao.getDirectoryList(type);
      if (CollectionUtils.isNotEmpty(directoryList)) {
        List<Integer> directoryIds =
            directoryList.stream().map(DirectoryDO::getId).collect(Collectors.toList());
        List<Categories> categoriesList =
            categoriesDao.getCategoriesListByDirectoryIds(directoryIds);
        return ResultBody.success(
            categoriesList.stream()
                .map(Categories::buildCategoryTypeDTO)
                .collect(Collectors.toList()));
      }
    } else if (type.equals(5)) {
      List<Categories> categoriesList = categoriesDao.listCategoryByInsurance();
      return ResultBody.success(
          categoriesList.stream()
              .map(Categories::buildCategoryTypeDTO)
              .collect(Collectors.toList()));
    } else if (type.equals(6)) {
      List<Categories> categoriesList = categoriesDao.listCategoryBySoftware();
      return ResultBody.success(
          categoriesList.stream()
              .map(Categories::buildCategoryTypeDTO)
              .collect(Collectors.toList()));
    }
    return ResultBody.success();
  }

  @Override
  public ResultBody<AdDTO> ad() {
    List<AdDO> ad = webDeviceDao.ad();
    List<AdDTO> collect =
        ad.stream()
            .map(
                t -> {
                  return t.adDTO();
                })
            .collect(Collectors.toList());
    return ResultBody.success(collect);
  }

  @Override
  public List<SkuInfoDTO> listWareSkuById(Integer id) {
    List<SkuInfoDO> skuInfoDOS = webDeviceDao.listSkuInfo(id);
    return skuInfoDOS.isEmpty()
        ? null
        : skuInfoDOS.stream()
            .map(
                d -> {
                  return d.buildSkuInfoDTO();
                })
            .collect(Collectors.toList());
  }

  @Override
  public ResultBody<ProductSpecCPQVO> getLeaseGoodsPriceDetail(
      Integer productSpecId, Integer leaseTerm) {
    ProductSpecCPQVO productSpecCPQVO = new ProductSpecCPQVO();
    List<SpecPriceVO> specPriceList = goodsInfoDao.getPriceBySpecId(productSpecId, leaseTerm);
    productSpecCPQVO.setProductSpecId(productSpecId);
    productSpecCPQVO.setLeaseTerm(leaseTerm);
    productSpecCPQVO.setSpecPrice(specPriceList);
    return ResultBody.success(productSpecCPQVO);
  }
}
