package com.mmc.pms.service.inspection.impl;

import com.mmc.pms.auth.dto.CompanyInfoVO;
import com.mmc.pms.auth.dto.LoginSuccessDTO;
import com.mmc.pms.common.ResultBody;
import com.mmc.pms.dao.inspection.CompanyInspectionDao;
import com.mmc.pms.entity.inspection.CompanyInspectionDO;
import com.mmc.pms.enums.CompanyTypeEnums;
import com.mmc.pms.enums.InspectionPriceUnitEnums;
import com.mmc.pms.feign.UserAppApi;
import com.mmc.pms.model.inspection.dto.CompanyInspectionDTO;
import com.mmc.pms.model.inspection.dto.IndustryTypeDTO;
import com.mmc.pms.model.inspection.vo.CompanyInspectionVO;
import com.mmc.pms.model.qo.CompanyInspectionQO;
import com.mmc.pms.page.PageResult;
import com.mmc.pms.service.inspection.CompanyInspectionService;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author: zj
 * @Date: 2023/8/7 14:31
 */
@Service
public class CompanyInspectionServiceImpl implements CompanyInspectionService {
    @Autowired
    private CompanyInspectionDao companyInspectionDao;

    @Autowired
    private UserAppApi userAppApi;

    @Override
    public ResultBody insert(CompanyInspectionVO companyInspectionVO) {
        CompanyInspectionDO companyInspectionDO = new CompanyInspectionDO(companyInspectionVO);
        companyInspectionDao.insert(companyInspectionDO);
        // 插入图片、视频
        if (CollectionUtils.isNotEmpty(companyInspectionVO.getCompanyInspectionFiles())) {
            companyInspectionVO.getCompanyInspectionFiles().stream().forEach(i -> i.setCompanyInspectionId(companyInspectionDO.getId()));
            companyInspectionDao.batchInsertCompanyInspectionFile(companyInspectionVO.getCompanyInspectionFiles());
        }
        return ResultBody.success();
    }

    @Override
    public ResultBody update(CompanyInspectionVO companyInspectionVO) {
        CompanyInspectionDO companyInspectionDO = new CompanyInspectionDO(companyInspectionVO);
        companyInspectionDao.update(companyInspectionDO);
        // 修改插入图片、视频
        return ResultBody.success();
    }

    @Override
    public ResultBody remove(Integer id) {
        companyInspectionDao.remove(id);
        return ResultBody.success();
    }

    @Override
    public ResultBody<CompanyInspectionDTO> getCompanyInspectionById(Integer id, LoginSuccessDTO loginSuccessDTO) {
        CompanyInspectionDO companyInspectionDO = companyInspectionDao.getCompanyInspectionById(id);
        if (companyInspectionDO != null) {
            CompanyInspectionDTO companyInspectionDTO = companyInspectionDO.buildCompanyInspectionDTO();
            ResultBody<CompanyInfoVO> res = userAppApi.getCompanyInfoById(companyInspectionDO.getCompanyInfoId(), loginSuccessDTO.getToken());
            if (res.getResult() != null) {
                companyInspectionDTO.setCompanyName(res.getResult().getCompanyName());
            }
            return ResultBody.success(companyInspectionDTO);
        }
        return ResultBody.success();
    }

    @Override
    public ResultBody<CompanyInspectionDTO> listCompanyInspectionPage(CompanyInspectionQO companyInspectionQO, LoginSuccessDTO loginSuccessDTO) {
        if (loginSuccessDTO.getCompanyInfoVO().getCompanyType().equals(CompanyTypeEnums.FRANCHISEE.getType())) {
            companyInspectionQO.setCompanyInfoId(loginSuccessDTO.getCompanyInfoVO().getId());
        }
        int count = companyInspectionDao.countListCompanyInspectionPage(companyInspectionQO);
        if (count == 0) {
            return ResultBody.success(PageResult.buildPage(companyInspectionQO.getPageNo(), companyInspectionQO.getPageSize(), count));
        }
        int pageNo = companyInspectionQO.getPageNo();
        companyInspectionQO.buildCurrentPage();
        List<CompanyInspectionDO> companyInspectionDOS = companyInspectionDao.listCompanyInspectionPage(companyInspectionQO);
        List<CompanyInspectionDTO> companyInspectionDTOS = companyInspectionDOS.stream().map(CompanyInspectionDO::buildCompanyInspectionDTO).collect(Collectors.toList());
        // 设置单位名称
        setCompanyName(companyInspectionDTOS, loginSuccessDTO.getToken());
        return ResultBody.success(PageResult.buildPage(pageNo, companyInspectionQO.getPageSize(), count, companyInspectionDTOS));
    }

    @Override
    public ResultBody updateRemark(Integer id, String remark) {
        companyInspectionDao.updateRemark(id, remark);
        return ResultBody.success();
    }

    @Override
    public ResultBody listInspectionPriceUnit() {
        List<Map<String, Object>> list = new ArrayList<>();
        for (InspectionPriceUnitEnums inspectionPriceUnitEnums : InspectionPriceUnitEnums.values()) {
            Map<String, Object> map = new HashMap<>();
            map.put("id", inspectionPriceUnitEnums.getId());
            map.put("unitName", inspectionPriceUnitEnums.getUnitName());
            list.add(map);
        }
        return ResultBody.success(list);
    }

    @Override
    public ResultBody<IndustryTypeDTO> listAPPCompanyInspectionPage(CompanyInspectionQO companyInspectionQO, LoginSuccessDTO loginSuccessDTO) {
        int count = companyInspectionDao.countListAPPCompanyInspectionPage(companyInspectionQO);
        if (count == 0) {
            return ResultBody.success(PageResult.buildPage(companyInspectionQO.getPageNo(), companyInspectionQO.getPageSize(), count));
        }
        int pageNo = companyInspectionQO.getPageNo();
        companyInspectionQO.buildCurrentPage();
        List<CompanyInspectionDO> companyInspectionDOS = companyInspectionDao.listAPPCompanyInspectionPage(companyInspectionQO);
        List<CompanyInspectionDTO> companyInspectionDTOS = companyInspectionDOS.stream().map(CompanyInspectionDO::buildCompanyInspectionDTO).collect(Collectors.toList());
        setCompanyName(companyInspectionDTOS, loginSuccessDTO.getToken());
        return ResultBody.success(PageResult.buildPage(pageNo, companyInspectionQO.getPageSize(), count, companyInspectionDTOS));
    }

    public void setCompanyName(List<CompanyInspectionDTO> companyInspectionDTOS, String token){
        // 单位名称查询
        List<Integer> companyInfoIds = companyInspectionDTOS.stream().map(i -> i.getCompanyInfoId()).collect(Collectors.toList());
        List<CompanyInfoVO> companyInfoVOS = userAppApi.feignListCompanyInfoByIds(companyInfoIds, token);
        if (CollectionUtils.isNotEmpty(companyInfoVOS)){
            Map<Integer, String> collect = companyInfoVOS.stream().collect(Collectors.toMap(CompanyInfoVO::getId, CompanyInfoVO::getCompanyName));
            companyInspectionDTOS.stream().forEach(i -> i.setCompanyName(collect.get(i.getCompanyInfoId())));
        }
    }
}
