package com.mmc.pms.model.category.qo;

import com.mmc.pms.common.Page;
import com.mmc.pms.model.group.Freeze;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

/**
 * @Author small
 * @Date 2023/7/21 15:22
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class CategoryQO {

    private static final long serialVersionUID = -3729786590325257669L;
    @ApiModelProperty(value = "一级分类id", required = false, example = "1")
    private Integer id;

    @ApiModelProperty(value = "当前页", required = true, example = "1")
    @NotNull(message = "当前页不能为空", groups = {Page.class, Freeze.class})
    @Min(value = 1, groups = Page.class)
    private Integer pageNo;

    @ApiModelProperty(value = "页大小", required = true, example = "10")
    @NotNull(message = "页大小不能为空", groups = {Page.class, Freeze.class})
    @Min(value = 1, groups = Page.class)
    private Integer pageSize;

    public void buildCurrentPage() {
        this.pageNo = (pageNo - 1) * pageSize;
    }
}
