package com.mmc.pms.entity.inspection;

import com.mmc.pms.model.inspection.dto.InspectionDTO;
import com.mmc.pms.model.inspection.vo.IndustryTypeVO;
import com.mmc.pms.model.inspection.vo.InspectionVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @author: zj
 * @Date: 2023/8/3 16:36
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class InspectionDO implements Serializable {
    private static final long serialVersionUID = -6888618752080050167L;
    private Integer id;
    /**
     * 服务编号
     */
    private String inspectionNo;
    /**
     * 服务名称
     */
    private String inspectionName;
    /**
     * 行业类型id
     */
    private Integer industryTypeId;
    /**
     * 服务图标
     */
    private String inspectionImg;
    /**
     * 服务描述
     */
    private String inspectionDescription;
    /**
     * 销售状态，0停售，1在售
     */
    private Integer saleState;
    /**
     * 案例图
     */
    private String caseImg;
    /**
     * 案例视频
     */
    private String caseVideo;
    /**
     * 生成时间
     */
    private Date createTime;

    public InspectionDO(InspectionVO inspectionVO){
        this.id = inspectionVO.getId();
        this.industryTypeId = inspectionVO.getIndustryTypeId();
        this.inspectionName = inspectionVO.getInspectionName();
        this.inspectionNo = inspectionVO.getInspectionNo();
        this.inspectionDescription = inspectionVO.getInspectionDescription();
        this.inspectionImg = inspectionVO.getInspectionImg();
        this.saleState = inspectionVO.getSaleState();
        this.caseImg = inspectionVO.getCaseImg();
        this.caseVideo = inspectionVO.getCaseVideo();
    }

    public InspectionDTO buildInspectionDTO(){
        return InspectionDTO.builder().id(this.id).industryTypeId(this.industryTypeId).inspectionNo(this.inspectionNo)
                .inspectionName(this.inspectionName).inspectionDescription(this.inspectionDescription).inspectionImg(this.inspectionImg)
                .saleState(this.saleState).caseImg(this.caseImg).caseVideo(this.caseVideo).build();
    }

}
