package com.mmc.pms.controller.inspection;

import com.mmc.pms.common.Page;
import com.mmc.pms.common.ResultBody;
import com.mmc.pms.model.inspection.dto.IndustryTypeDTO;
import com.mmc.pms.model.inspection.vo.IndustryTypeVO;
import com.mmc.pms.model.qo.IndustryTypeQO;
import com.mmc.pms.service.inspection.IndustryTypeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * @author: zj
 * @Date: 2023/8/3 17:58
 */
@Api(tags = {"行业类型"})
@RestController
@RequestMapping("/industry/")
public class IndustryTypeController {
    @Autowired
    private IndustryTypeService industryTypeService;

    @ApiOperation(value = "新增行业")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("insert")
    public ResultBody insert(@RequestBody IndustryTypeVO industryTypeVO){
        return industryTypeService.insert(industryTypeVO);
    }

    @ApiOperation(value = "修改行业")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("update")
    public ResultBody update(@RequestBody IndustryTypeVO industryTypeVO){
        return industryTypeService.update(industryTypeVO);
    }

    @ApiOperation(value = "删除行业")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("remove")
    public ResultBody remove(@RequestParam Integer id){
        return industryTypeService.remove(id);
    }

    @ApiOperation(value = "一级行业列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("listPages")
    public ResultBody<IndustryTypeDTO> listPages(@Validated(value = {Page.class}) @RequestBody IndustryTypeQO industryTypeQO){
        return industryTypeService.listPages(industryTypeQO);
    }

    @ApiOperation(value = "根据一级行业id查询二级服务列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = IndustryTypeDTO.class)})
    @GetMapping("listInspectionsByIndustryTypeId")
    public ResultBody<IndustryTypeDTO> listInspectionsByIndustryTypeId(@RequestParam Integer id){
        return industryTypeService.listInspectionsByIndustryTypeId(id);
    }
}
