package com.mmc.pms.service.Impl;

import com.google.common.collect.Lists;
import com.mmc.pms.common.ResultBody;
import com.mmc.pms.dao.BackstageTaskServiceDao;
import com.mmc.pms.dao.CategoriesDao;
import com.mmc.pms.entity.Categories;
import com.mmc.pms.entity.ServiceDO;
import com.mmc.pms.model.qo.ServiceQO;
import com.mmc.pms.model.work.dto.ServiceDTO;
import com.mmc.pms.model.work.vo.ServiceVO;
import com.mmc.pms.page.PageResult;
import com.mmc.pms.service.BackstageTaskService;
import com.mmc.pms.service.CategoriesService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @Author LW
 * @date 2023/6/8 9:59
 * 概要：
 */
@Service
public class BackstageTaskServiceImpl implements BackstageTaskService {

    @Autowired
    private BackstageTaskServiceDao backstageTaskServiceDao;

    @Autowired
    private CategoriesDao categoriesDao;

    @Override
    public ResultBody addWorkService(ServiceVO param, Integer userAccountId) {
        ServiceDO serviceDO = new ServiceDO(param, userAccountId);
        backstageTaskServiceDao.insert(serviceDO);
        return ResultBody.success();
    }

    @Override
    public ResultBody updateById(ServiceVO param) {
        ServiceDO serviceDO = new ServiceDO(param);
        backstageTaskServiceDao.update(serviceDO);
        return ResultBody.success();
    }

    @Override
    public ResultBody deleteById(Integer id) {
        backstageTaskServiceDao.deleteById(id);
        return ResultBody.success();
    }

    @Override
    public ResultBody queryById(Integer id) {
        ServiceDO serviceDO = backstageTaskServiceDao.queryById(id);
        ServiceDTO serviceDTO = new ServiceDTO(serviceDO);
        Map<Integer, String> categoriesNameMap = getCategoriesNameByIds(Arrays.asList(serviceDTO.getApplicationId(),serviceDTO.getIndustryId()));
        if(!CollectionUtils.isEmpty(categoriesNameMap)){
            serviceDTO.setApplicationName(categoriesNameMap.get(serviceDTO.getApplicationId()));
            serviceDTO.setIndustryName(categoriesNameMap.get(serviceDTO.getIndustryId()));
        }
        return ResultBody.success(serviceDTO);
    }

    private Map<Integer,String> getCategoriesNameByIds(List<Integer> ids){
        if(CollectionUtils.isEmpty(ids)){
            return new HashMap<>();
        }
        Set<Integer> idSet = new HashSet<>();
        for (Integer id : ids) {
            idSet.add(id);
        }
        List<Categories> categories = categoriesDao.getCategoriesListByIds(idSet);
        if(CollectionUtils.isEmpty(categories)){
            return new HashMap<>();
        }
        return categories.stream().collect(Collectors.toMap(Categories::getId, d -> d.getName(), (k1, k2) -> k1));
    }

    @Override
    public PageResult queryWorkServiceList(ServiceQO param, Integer userAccountId) {
        int count = backstageTaskServiceDao.count(param);
        if(count == 0){
            return PageResult.buildPage(param.getPageNo(), param.getPageSize(),count);
        }
        Integer pageNo = param.getPageNo();
        param.buildCurrentPage();
        List<ServiceDO> services = backstageTaskServiceDao.queryAllByLimit(param);
        List<Integer> list = new ArrayList<>();
        for (ServiceDO service : services) {
            list.add(service.getApplicationId());
            list.add(service.getIndustryId());
        }
        Map<Integer, String> categoriesNameMap = getCategoriesNameByIds(list);
        List<ServiceDTO> pageList = services.stream().map(d->{
            ServiceDTO serviceDTO = new ServiceDTO(d);
            serviceDTO.setApplicationName(categoriesNameMap.get(d.getApplicationId()));
            serviceDTO.setIndustryName(categoriesNameMap.get(d.getIndustryId()));
            return serviceDTO;
        }).collect(Collectors.toList());
        return PageResult.buildPage(pageNo, param.getPageSize(),count,pageList);
    }
}
