package com.mmc.pms.service;

import com.mmc.pms.common.ResultBody;
import com.mmc.pms.entity.Categories;
import com.mmc.pms.entity.DirectoryDO;
import com.mmc.pms.entity.DistrictDO;
import com.mmc.pms.model.categories.vo.CategoriesInfoVO;
import com.mmc.pms.model.categories.vo.ClassifyInfoVO;
import com.mmc.pms.model.categories.vo.DirectoryInfoVO;
import com.mmc.pms.model.sale.vo.QueryClassifyVO;
import com.mmc.pms.page.PageResult;

import java.util.List;
import java.util.Set;

/**
 * @author 23214
 * @description 针对表【categories(通用分类表)】的数据库操作Service
 * @createDate 2023-05-24 10:29:28
 */
public interface CategoriesService {

    ResultBody addOrEditDirectory(DirectoryInfoVO param);

    PageResult directoryList(Integer pageNo, Integer pageSize, Integer type);

    ResultBody removeDirectory(Integer id);

    ResultBody addClassification(ClassifyInfoVO classifyInfoVO);

    ResultBody updateClassification(ClassifyInfoVO classifyInfoVO);

    ResultBody exchangeSortType(Integer firstId, Integer secondId);

    PageResult getClassificationList(QueryClassifyVO queryClassifyVO);

    ResultBody getClassifyDetails(Integer id);

    ResultBody queryRelevantBusiness(Integer id, Integer type);

    ResultBody deleteRelevantBusiness(Integer id);

    ResultBody getDirectoryList(Integer type);

    List<Categories> getCategoriesListByDirectoryName(String directoryName);

    ResultBody getApplicationList(String directoryName);

    List<Categories> getCategoriesListByIds(Set<Integer> ids);

}
