package com.mmc.pms.auth;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

/**
 * @author: zj
 * @Date: 2023/5/28 10:52
 */
@Configuration
public class MvcConfiguration implements WebMvcConfigurer {

    @Autowired
    private TokenCheckHandleInterceptor tokenCheckHandleInterceptor;

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor(tokenCheckHandleInterceptor);
        WebMvcConfigurer.super.addInterceptors(registry);
    }
}
