package com.mmc.pms.model.lease.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @Author small @Date 2023/5/16 10:02 @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(description = "商品视频DTO")
public class WareInfoDTO implements Serializable {
  private static final long serialVersionUID = -4916469576205012865L;

  @ApiModelProperty(value = "ID")
  private Integer id;

  @ApiModelProperty(value = "商品编号")
  private String wareNo;

  @ApiModelProperty(value = "商品标题")
  private String wareTitle;

  @ApiModelProperty(value = "商品类型ID")
  private Integer wareTypeId;

  @ApiModelProperty(value = "商品状态")
  private Integer wareStatus;

  @ApiModelProperty(value = "减库方式")
  private Integer payStatus;

  @ApiModelProperty(value = "最小押金")
  private BigDecimal minDeposit;

  @ApiModelProperty(value = "最大押金")
  private BigDecimal maxDeposit;

  @ApiModelProperty(value = "最小租金")
  private BigDecimal minRent;

  @ApiModelProperty(value = "最大租金")
  private BigDecimal maxRent;

  @ApiModelProperty(value = "总库存数量")
  private Integer totalStock;

  @ApiModelProperty(value = "总销量")
  private Integer totalSale;

  @ApiModelProperty(value = "sku数量")
  private Integer skuNum;

  @ApiModelProperty(value = "标签集合")
  private List<String> tags;

  @ApiModelProperty(value = "商品图片集合")
  private List<WareImgDTO> wareImgs;
  //	@ApiModelProperty(value = "商品视频集合")
  //	private List<WareVideoDTO> wareVideos;
  @ApiModelProperty(value = "商品活动对象")
  private WarePropDTO warePropDTO;

  @ApiModelProperty(value = "商品介绍详情")
  private String wareDetailContent;
  //	@ApiModelProperty(value = "商品介绍详情")
  //	private WareDetailDTO wareDetailDTO;
  //	@ApiModelProperty(value = "商品sku信息")
  //	private List<SkuInfoDTO> skuInfoDTOList;
}
