package com.mmc.pms.feign.hystrix;

import com.mmc.pms.auth.dto.BUserAccountQO;
import com.mmc.pms.auth.dto.CompanyInfoDTO;
import com.mmc.pms.auth.dto.CompanyInfoVO;
import com.mmc.pms.auth.dto.UserAccountSimpleDTO;
import com.mmc.pms.feign.UserAppApi;
import com.mmc.pms.model.qo.CompanyInfoQO;
import com.mmc.pms.model.qo.UserAccountQO;
import lombok.extern.slf4j.Slf4j;

import java.util.List;

/**
 * @author: zj
 * @Date: 2023/5/18 17:08
 */
@Slf4j
public class UserAppApiHystrix implements UserAppApi {
    @Override
    public UserAccountSimpleDTO feignGetUserSimpleInfo(Integer userAccountId, String token) {
        log.error("熔断：feignGetUserSimpleInfo：{}", userAccountId);
        return null;
    }

    @Override
    public List<Integer> feignListUserAccountIds(Integer provinceCode, Integer cityCode, Integer districtCode, String token) {
        log.error("熔断：feignListUserAccountIds：{}， {}， {}", provinceCode, cityCode, districtCode);
        return null;
    }

    @Override
    public List<UserAccountSimpleDTO> feignListBAccountPage(BUserAccountQO bUserAccountQO, String token) {
        log.error("熔断：feignListBAccountPage：{}", bUserAccountQO);
        return null;
    }

    @Override
    public List<UserAccountSimpleDTO> feignListAppUserAccount(UserAccountQO userAccountQO, String token) {
        log.error("熔断：feignListAppUserAccount：{}", userAccountQO);
        return null;
    }

    @Override
    public String getCompanyInfoById(Integer id, String token) {
        log.error("熔断：feignListAppUserAccount：{}", id);
        return null;
    }

    @Override
    public List<CompanyInfoVO> listCompanyPage(CompanyInfoQO companyInfoQO, String token) {
        log.error("熔断：feignListAppUserAccount：{}", companyInfoQO);
        return null;
    }
}
