package com.mmc.pms.feign.config;

import com.mmc.pms.feign.hystrix.ImsApiHystrix;
import com.mmc.pms.feign.hystrix.UserAppApiHystrix;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

/**
 * @author: zj @Date: 2023/5/18 18:21
 */
@ComponentScan(basePackages = "com.mmc.pms.feign")
@Configuration
public class FeignConfiguration {

  @Bean(name = "userAppApiHystrix")
  public UserAppApiHystrix userAppApi() {
    return new UserAppApiHystrix();
  }

  @Bean(name = "imsApiHystrix")
  public ImsApiHystrix imsAppApi() {
    return new ImsApiHystrix();
  }
}
