package com.mmc.pms.feign.hystrix;

import com.mmc.pms.feign.ImsAppApi;
import com.mmc.pms.model.categories.vo.CurriculumInfoVO;
import lombok.extern.slf4j.Slf4j;

import java.util.List;

/**
 * @Author LW
 * @date 2023/6/15 10:47 概要：
 */
@Slf4j
public class ImsApiHystrix implements ImsAppApi {
    @Override
    public List<CurriculumInfoVO> feignCurriculumInfoList(Integer categoriesId) {
        log.error("熔断：feignCurriculumInfoList：{}", categoriesId);
        return null;
    }

    @Override
    public int feignCountCurriculumInfo(Integer categoriesId) {
        log.error("熔断：feignCountCurriculumInfo：{}", categoriesId);
        return 0;
    }

    @Override
    public Integer getCurriculumCount() {
        log.error("熔断：ImsApiHystrix.feignCountCurriculumInfo");
        return 0;
    }

//    @Override
//    public List<CurriculumInfoVO> queryCurriculumInfoById(List<Integer> ids) {
//        log.error("熔断：ImsApiHystrix.queryCurriculumInfoById");
//        return null;
//    }
}
