package com.mmc.pms.service.Impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.mmc.pms.common.ResultBody;
import com.mmc.pms.constant.DateConstant;
import com.mmc.pms.dao.BackstageTaskServiceDao;
import com.mmc.pms.dao.CategoriesDao;
import com.mmc.pms.entity.Categories;
import com.mmc.pms.entity.InspComtDO;
import com.mmc.pms.entity.ServiceDO;
import com.mmc.pms.feign.UserAppApi;
import com.mmc.pms.model.qo.ServiceQO;
import com.mmc.pms.model.work.dto.ServiceDTO;
import com.mmc.pms.model.work.dto.WorkServiceDTO;
import com.mmc.pms.model.work.vo.ServiceVO;
import com.mmc.pms.model.work.vo.UpAndDownServiceVO;
import com.mmc.pms.page.PageResult;
import com.mmc.pms.service.BackstageTaskService;
import com.mmc.pms.service.InspComtService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * @Author LW
 *
 * @date 2023/6/8 9:59 概要：
 */
@Service
@Slf4j
public class BackstageTaskServiceImpl implements BackstageTaskService {

  @Autowired private BackstageTaskServiceDao backstageTaskServiceDao;

  @Autowired private CategoriesDao categoriesDao;

  @Autowired private UserAppApi userAppApi;

  @Autowired private InspComtService inspComtService;

  @Autowired private RedisTemplate redisTemplate;

  @Override
  public ResultBody addWorkService(ServiceVO param, Integer userAccountId) {
    ServiceDO serviceDO = new ServiceDO(param, userAccountId);
    backstageTaskServiceDao.insert(serviceDO);
    return ResultBody.success();
  }

  @Override
  public ResultBody updateById(ServiceVO param) {
    ServiceDO serviceDO = new ServiceDO(param);
    backstageTaskServiceDao.update(serviceDO);
    return ResultBody.success();
  }

  @Override
  public ResultBody deleteByIds(List<Integer> ids) {
    if (!CollectionUtils.isEmpty(ids)) {
      backstageTaskServiceDao.deleteByIds(ids);
    }
    return ResultBody.success();
  }

  @Override
  public ResultBody<ServiceDTO> queryById(Integer id) {
    ServiceDO serviceDO = backstageTaskServiceDao.queryById(id);
    ServiceDTO serviceDTO = new ServiceDTO(serviceDO);
    Map<Integer, String> categoriesNameMap =
        getCategoriesNameByIds(
            Arrays.asList(serviceDTO.getApplicationId(), serviceDTO.getIndustryId()));
    if (!CollectionUtils.isEmpty(categoriesNameMap)) {
      serviceDTO.setApplicationName(categoriesNameMap.get(serviceDTO.getApplicationId()));
      serviceDTO.setIndustryName(categoriesNameMap.get(serviceDTO.getIndustryId()));
    }
    List<InspComtDO> inspComtList = RandomGetInspComt(id);
    serviceDTO.setInspComtList(inspComtList);
    serviceDTO.setInspComtAmount(inspComtList.size());
    return ResultBody.success(serviceDTO);
  }

  private Map<Integer, String> getCategoriesNameByIds(List<Integer> ids) {
    if (CollectionUtils.isEmpty(ids)) {
      return new HashMap<>();
    }
    Set<Integer> idSet = new HashSet<>();
    for (Integer id : ids) {
      idSet.add(id);
    }
    List<Categories> categories = categoriesDao.getCategoriesListByIds(idSet);
    if (CollectionUtils.isEmpty(categories)) {
      return new HashMap<>();
    }
    return categories.stream()
        .collect(Collectors.toMap(Categories::getId, d -> d.getName(), (k1, k2) -> k1));
  }

  @Override
  public PageResult queryServiceManagerList(ServiceQO param, Integer userAccountId) {
    int count = backstageTaskServiceDao.count(param);
    if (count == 0) {
      return PageResult.buildPage(param.getPageNo(), param.getPageSize(), count);
    }
    Integer pageNo = param.getPageNo();
    param.buildCurrentPage();
    List<ServiceDO> services = backstageTaskServiceDao.queryAllByLimit(param);
    List<ServiceDTO> pageList = setApplicationNameAndIndustryName(services);
    return PageResult.buildPage(pageNo, param.getPageSize(), count, pageList);
  }

  private List<ServiceDTO> setApplicationNameAndIndustryName(List<ServiceDO> services) {
    List<Integer> list = new ArrayList<>();
    for (ServiceDO service : services) {
      list.add(service.getApplicationId());
      list.add(service.getIndustryId());
    }
    Map<Integer, String> categoriesNameMap = getCategoriesNameByIds(list);
    List<ServiceDTO> pageList =
        services.stream()
            .map(
                d -> {
                  ServiceDTO serviceDTO = new ServiceDTO(d);
                  serviceDTO.setApplicationName(categoriesNameMap.get(d.getApplicationId()));
                  serviceDTO.setIndustryName(categoriesNameMap.get(d.getIndustryId()));
                  return serviceDTO;
                })
            .collect(Collectors.toList());
    return pageList;
  }

  @Override
  public PageResult queryWorkServiceList(ServiceQO param, HttpServletRequest request) {
    log.info(
        "开始queryWorkServiceList==>{}",
        JSONObject.toJSONString(DateFormatUtils.format(new Date(), DateConstant.YYYYMMDDHHMMSS)));
    Integer pageNo = param.getPageNo();
    param.buildCurrentPage();
    List<Integer> userIds = null;
    Integer provinceCode = param.getProvinceId();
    if (provinceCode != null) {
      userIds = userAppApi.feignListUserAccountIds(provinceCode, null, null, null);
      if (userIds == null || userIds.size() == 0) {
        userIds = Arrays.asList(-1);
      }
    }
    List<Integer> categoriesIds = param.getCategoryId();
    int count = backstageTaskServiceDao.conditionCount(param, categoriesIds, userIds);
    if (count == 0) {
      return PageResult.buildPage(param.getPageNo(), param.getPageSize(), count);
    }
    List<ServiceDO> pageList =
        backstageTaskServiceDao.queryPageByLimit(param, categoriesIds, userIds);

    List<WorkServiceDTO> workServiceDTOList = getWorkServiceDTOS(pageList);
    log.info(
        "结束queryWorkServiceList==>{}",
        JSONObject.toJSONString(DateFormatUtils.format(new Date(), DateConstant.YYYYMMDDHHMMSS)));
    return PageResult.buildPage(pageNo, param.getPageSize(), count, workServiceDTOList);
  }

  @Override
  public List<ServiceDTO> feignQueryWorkServiceListById(List<Integer> ids) {
    return backstageTaskServiceDao.QueryWorkServiceListById(ids);
  }

  @Override
  public ResultBody batchUpAndDownWorkService(UpAndDownServiceVO param) {
    if (!CollectionUtils.isEmpty(param.getIds())) {
      backstageTaskServiceDao.batchUpAndDownWorkService(param);
    }
    return ResultBody.success();
  }

  @Override
  public Integer getWorkServiceCountByCategoriesId(List<Integer> ids) {
    if (CollectionUtils.isEmpty(ids)) {
      return 0;
    }
    return backstageTaskServiceDao.getWorkServiceCountByCategoriesId(ids);
  }

  private List<WorkServiceDTO> getWorkServiceDTOS(List<ServiceDO> pageList) {
    // 用户暂时无关联公司数据，先用假数据展示
    String companyName = "浙江科比特创新科技有限公司";
    List<WorkServiceDTO> workServiceDTOList = new ArrayList<>();
    for (ServiceDO item : pageList) {
      WorkServiceDTO workServiceDTO =
          WorkServiceDTO.builder()
              .id(item.getId())
              .serviceName(item.getServiceName())
              .companyName(companyName)
              .coverPlan(item.getCoverPlan())
              .serviceIntroduction(item.getServiceIntroduction())
              .video(item.getVideo())
              .shareCard(item.getShareCard())
              .build();
      workServiceDTOList.add(workServiceDTO);
    }
    return workServiceDTOList;
  }

  /** 根据id随机获取50条以上的评论 */
  private List<InspComtDO> RandomGetInspComt(Integer id) {
    String listStr = (String) redisTemplate.opsForValue().get(id);
    List<InspComtDO> inspComtRandomList = null;
    if (StringUtils.isNotBlank(listStr)) {
      inspComtRandomList = JSONArray.parseArray(listStr, InspComtDO.class);
    } else {
      inspComtRandomList = inspComtService.randomGetInspComtList(RandomUtils.nextInt(50, 9999));
      String toJSONString = JSONObject.toJSONString(inspComtRandomList);
      redisTemplate.opsForValue().set(id, toJSONString, 2L, TimeUnit.DAYS);
    }
    return inspComtRandomList;
  }
}
