package com.mmc.pms.service.mall.impl;

import com.mmc.pms.common.ResultBody;
import com.mmc.pms.dao.mall.AppMallGoodsDao;
import com.mmc.pms.entity.mall.MallGoodsDO;
import com.mmc.pms.model.mall.GoodsListVO;
import com.mmc.pms.model.mall.MallGoodsVO;
import com.mmc.pms.service.mall.AppMallGoodsService;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Author LW
 * @date 2023/7/26 14:55
 * 概要：
 */
@Service
public class AppMallGoodsServiceImpl implements AppMallGoodsService {
    @Resource
    private AppMallGoodsDao appMallGoodsDao;

    @Override
    public ResultBody<MallGoodsVO> queryBrandGoods(Integer userAccountId) {
        List<MallGoodsDO> mallGoodsList = appMallGoodsDao.queryGoodsInfo(userAccountId, null);
        return checkGoodsInfo(mallGoodsList);
    }


    @Override
    public ResultBody<MallGoodsVO> queryGoodsInfoByCategorySub(List<Integer> categorySubIds) {
        List<MallGoodsDO> mallGoodsList = appMallGoodsDao.queryGoodsInfo(null, categorySubIds);
        return checkGoodsInfo(mallGoodsList);
    }

    private ResultBody<MallGoodsVO> checkGoodsInfo(List<MallGoodsDO> mallGoodsList) {
        if (CollectionUtils.isNotEmpty(mallGoodsList)) {
            return ResultBody.success(mallGoodsList.stream().map(MallGoodsDO::buildListMallGoodsVO).collect(Collectors.toList()));
        }
        return ResultBody.success();
    }

    @Override
    public ResultBody<GoodsListVO> brandStoreList(List<Integer> userAccountIds) {
        List<GoodsListVO> goodsList = new ArrayList<>();
        List<MallGoodsDO> mallGoodsDOList = appMallGoodsDao.brandStoreList(userAccountIds);
        List<MallGoodsVO> list = mallGoodsDOList.stream().map(MallGoodsDO::buildListMallGoodsVO).collect(Collectors.toList());
        Map<Integer, List<MallGoodsVO>> map = list.
                stream().collect(Collectors.groupingBy(MallGoodsVO::getUserAccountId));
        for (Map.Entry<Integer, List<MallGoodsVO>> entry : map.entrySet()) {
            GoodsListVO goodsListVO = new GoodsListVO();
            goodsListVO.setUserAccountId(entry.getKey());
            goodsListVO.setMallGoodsVOList(entry.getValue());
            goodsList.add(goodsListVO);
        }
        return ResultBody.success(goodsList);
    }
}
