package com.mmc.pms.service.category.impl;

import com.mmc.pms.common.ResultBody;
import com.mmc.pms.common.ResultEnum;
import com.mmc.pms.dao.category.ProductAttributeDao;
import com.mmc.pms.entity.category.ProductTypeDO;
import com.mmc.pms.model.category.vo.ProductTypeVO;
import com.mmc.pms.page.PageResult;
import com.mmc.pms.service.category.ProductAttributeService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @Author LW
 * @date 2023/8/5 10:44
 * 概要：
 */
@Service
public class ProductAttributeServiceImpl implements ProductAttributeService {
    @Resource
    ProductAttributeDao productAttributeDao;

    @Override
    public ResultBody addType(ProductTypeVO param) {
        int count = productAttributeDao.countTypeByName(param);
        if (count > 0) {
            return ResultBody.error(ResultEnum.GOODS_CATEGORY_NAME_EXIST_ERROR);
        }
        productAttributeDao.addType(param);
        return ResultBody.success();
    }

    @Override
    public ResultBody editType(ProductTypeVO param) {
        int count = productAttributeDao.countTypeByName(param);
        if (count > 0) {
            return ResultBody.error(ResultEnum.GOODS_CATEGORY_NAME_EXIST_ERROR);
        }
        productAttributeDao.editType(param);
        return ResultBody.success();
    }

    @Override
    public ResultBody removeType(Integer id) {
        // 判断该类型是否绑定产品信息
        int count = productAttributeDao.countLeaseGoodsByTypeId(id);
        if (count > 0) {
            return ResultBody.error(ResultEnum.TYPE_DELETE_FAIL);
        }
        productAttributeDao.removeType(id);
        return ResultBody.success();
    }

    @Override
    public ResultBody<ProductTypeVO> typeDetails(Integer id) {
        ProductTypeDO productType = productAttributeDao.getType(id);
        return ResultBody.success(productType == null ? null : productType.buildProductType());
    }

    @Override
    public PageResult typeList(Integer pageNo, Integer pageSize) {
        int count = productAttributeDao.countType();
        if (count == 0) {
            return PageResult.buildPage(pageNo, pageSize, count);
        }
        List<ProductTypeDO> productTypeList = productAttributeDao.listType((pageNo - 1) * pageSize, pageSize);
        return PageResult.buildPage(pageNo, pageSize, count, productTypeList.stream().map(ProductTypeDO::buildProductType).collect(Collectors.toList()));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ResultBody exchange(Integer firstId, Integer secondId) {
        ProductTypeDO firstType = productAttributeDao.getType(firstId);
        ProductTypeDO secondType = productAttributeDao.getType(secondId);
        int updateCount1 = productAttributeDao.updateProductAttribute(firstId, secondType.getCreateTime());
        int updateCount2 = productAttributeDao.updateProductAttribute(secondId, firstType.getCreateTime());
        if (updateCount1 == updateCount2) {
            return ResultBody.success();
        } else {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return ResultBody.error("排序失败");
        }
    }
}
