package com.mmc.pms.model.sale.vo;

import com.mmc.pms.model.group.Create;
import com.mmc.pms.model.group.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @Author LW
 * @date 2022/10/14 11:30
 * 概要：
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class GoodsAddVO implements Serializable {
    private static final long serialVersionUID = 7041502536618388167L;
    @ApiModelProperty(value = "商品类型：0：销售商品 1:租赁商品")
    @NotNull(message = "新增商品类型不能为空", groups = {Create.class})
    private Integer goodsType;
    @ApiModelProperty(value = "id")
    @NotNull(message = "修改时id不能为空", groups = {Update.class})
    private Integer id;
    @ApiModelProperty(value = "商品图片")
    @NotEmpty(message = "主图不能为空", groups = {Update.class, Create.class})
    private List<GoodsImgVO> images;
    @ApiModelProperty(value = "商品视频")
    private String goodsVideo;
    @ApiModelProperty(value = "商品名称")
    @NotNull(message = "商品名称不能为空", groups = {Update.class, Create.class})
    private String goodsName;
    @ApiModelProperty(value = "商品详情")
    private GoodsDetailVO goodsDetailVO;
    @ApiModelProperty(value = "所属目录")
    @NotNull(message = "所属目录不能为空", groups = {Update.class, Create.class})
    private Integer directoryId;
    @ApiModelProperty(value = "一级分类id")
    @NotNull(message = "分类不能为空", groups = {Update.class, Create.class})
    private Integer categoryByOne;
    @ApiModelProperty(value = "二级分类id")
    private Integer categoryByTwo;
    @ApiModelProperty(value = "商品标签")
    private String tag;
    @ApiModelProperty(value = "商品状态 0:下架 1:上架")
    private Integer shelfStatus;
    @ApiModelProperty(value = "规格信息")
    private List<GoodsProdSpecVO> productSpec;
    @ApiModelProperty(value = "其他服务: 1:免费配送，2：专业飞手培训2日， 3：半年保修， 4：一年保修 ")
    private List<Integer> otherService;
}
