package com.mmc.pms.service.category;

import com.mmc.pms.common.ResultBody;
import com.mmc.pms.model.category.vo.ProductTypeVO;
import com.mmc.pms.page.PageResult;

/**
 * @Author LW
 * @date 2023/8/5 10:43
 * 概要：
 */
public interface ProductAttributeService {
    /**
     * 添加类型
     *
     * @param param 参数
     * @return {@link ResultBody}
     */
    ResultBody addType(ProductTypeVO param);

    /**
     * 编辑类型
     *
     * @param param 参数
     * @return {@link ResultBody}
     */
    ResultBody editType(ProductTypeVO param);

    /**
     * 删除类型
     *
     * @param id id
     * @return {@link ResultBody}
     */
    ResultBody removeType(Integer id);

    /**
     * 类型详情
     *
     * @param id id
     * @return {@link ResultBody}<{@link ProductTypeVO}>
     */
    ResultBody<ProductTypeVO> typeDetails(Integer id);

    PageResult typeList(Integer pageNo, Integer pageSize);

    ResultBody exchange(Integer firstId, Integer secondId);
}
