package com.mmc.pms.model.sale.vo;

import com.mmc.pms.model.group.Create;
import com.mmc.pms.model.group.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Author LW
 * @date 2022/10/8 14:41
 * 概要：
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class IndustrySkuVO implements Serializable {
    private static final long serialVersionUID = 6388977489810960843L;
    @ApiModelProperty(value = "id")
    @NotNull(message = "id不能为空", groups = {Update.class})
    private Integer id;
    @ApiModelProperty(value = "方案名称")
    @NotNull(message = "方案名称不能为空", groups = {Create.class, Update.class})
    private String solutionName;
    @NotNull(message = "行业分类id不能为空", groups = {Create.class, Update.class})
    @ApiModelProperty(value = "所属行业分类id")
    private Integer categoryId;
    @ApiModelProperty(value = "行业名称")
    private String categoryName;
    @ApiModelProperty(value = "描述")
    private String description;
}
