package com.mmc.pms.model.other.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(description = "退款logDTO")
public class RefundLogDTO implements Serializable {
  private static final long serialVersionUID = 6524395508534109389L;

  @ApiModelProperty(value = "内容")
  private String msg;

  @ApiModelProperty(value = "账号")
  private String opAccount;

  @ApiModelProperty(value = "名称")
  private String opName;

  @ApiModelProperty(value = "创建/发送时间")
  private Date createTime;
}
