package com.mmc.pms.model.lease.vo;

import com.mmc.pms.model.group.Create;
import com.mmc.pms.model.group.Update;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Author small @Date 2023/5/16 17:21 @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(description = "新增/修改参数类")
public class WareSkuPriceVO implements Serializable {
    private static final long serialVersionUID = -3033801564005806565L;

    @ApiModelProperty(value = "sku对应的id")
    @NotNull(
            message = "sku对应的id不能为空",
            groups = {Update.class})
    private Integer id;

    @ApiModelProperty(value = "出租价格")
    @NotNull(
            message = "出租价格不能为空",
            groups = {Create.class})
    @Min(
            value = 0,
            message = "出租价格不能小于0",
            groups = {Create.class, Update.class})
    @Max(
            value = 100000000,
            message = "出租价格不能大于100000000",
            groups = {Create.class, Update.class})
    private BigDecimal rentPrice;

    @ApiModelProperty(value = "起租天数")
    @NotNull(
            message = "起租天数不能为空",
            groups = {Create.class})
    @Min(
            value = 0,
            message = "起租天数不能小于0",
            groups = {Create.class, Update.class})
    private Integer minDay;

    @ApiModelProperty(value = "最大天数")
    @NotNull(
            message = "最大天数不能为空",
            groups = {Create.class})
    @Min(
            value = 0,
            message = "最大天数不能小于0",
            groups = {Create.class, Update.class})
    private Integer maxDay;
}
