package com.mmc.pms.entity.lease;

import com.mmc.pms.model.lease.vo.LeasePriceStockVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 价格库存表(LeasePriceStockDO)实体类
 *
 * @author makejava
 * @since 2023-08-11 14:55:42
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class LeasePriceStockDO implements Serializable {
    private static final long serialVersionUID = 909783790755484524L;

    private Integer id;
    /**
     * 租赁商品id
     */
    private Integer leaseGoodsId;
    /**
     * 商品规格
     */
    private String productSpec;
    /**
     * sku图片
     */
    private String skuImage;
    /**
     * 押金
     */
    private BigDecimal cashPledge;

    /**
     * 3天租金
     */
    private BigDecimal threeDaysRental;
    /**
     * 7天租金
     */
    private BigDecimal sevenDaysRental;
    /**
     * 30天租金
     */
    private BigDecimal thirtyDaysRental;
    /**
     * 90天租金
     */
    private BigDecimal ninetyDaysRental;
    /**
     * 180天租金
     */
    private BigDecimal maxDaysRental;
    /**
     * 库存
     */
    private Integer stock;
    /**
     * 0：否 1：是
     */
    private Integer stockOut;

    private Date createTime;

    private Date updateTime;

    public LeasePriceStockDO(LeasePriceStockVO param, Integer id) {
        this.leaseGoodsId = id;
        this.productSpec = param.getProductSpec();
        this.cashPledge = param.getCashPledge();
        this.skuImage = param.getSkuImage();
        this.stock = param.getStock();
        this.threeDaysRental = param.getThreeDaysRental();
        this.sevenDaysRental = param.getSevenDaysRental();
        this.thirtyDaysRental = param.getThirtyDaysRental();
        this.ninetyDaysRental = param.getNinetyDaysRental();
        this.maxDaysRental = param.getMaxDaysRental();
        this.stockOut = param.getStockOut();
    }

    public LeasePriceStockVO buildPriceStockVO() {
        return LeasePriceStockVO.builder().id(id).productSpec(productSpec)
                .cashPledge(cashPledge).threeDaysRental(threeDaysRental)
                .sevenDaysRental(sevenDaysRental).thirtyDaysRental(thirtyDaysRental)
                .ninetyDaysRental(ninetyDaysRental).maxDaysRental(maxDaysRental)
                .skuImage(skuImage).stock(stock).stockOut(stockOut).build();
    }
}

