package com.mmc.pms.entity.category;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.mmc.pms.model.category.dto.CategoryPrimaryDTO;
import com.mmc.pms.model.category.vo.CategoryPrimaryVO;
import com.mmc.pms.model.group.Create;
import com.mmc.pms.model.group.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.util.Date;
import java.util.List;

/**
 * @Author small
 * @Date 2023/7/21 10:15
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class CategoryPrimaryDO {

    @ApiModelProperty(value = "id")
    @NotNull(message = "id不能为空", groups = {Update.class})
    @Min(value = 1, groups = {Update.class})
    @TableId(type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "分类名称", required = true, example = "无人机")
    @Size(max = 15, message = "分类名称不能超过15个字", groups = {Update.class, Create.class})
    @NotBlank(message = "分类名称不能为空或空字符", groups = {Update.class, Create.class})
    private String name;

    @ApiModelProperty(value = "描述")
    @Size(max = 70, message = "分类描述不能超过70个字", groups = {Update.class, Create.class})
    private String description;

    @ApiModelProperty(value = "icon图标")
    private String icon;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建时间", example = "2023-07-14 10:13:12", required = true)
    private Date createTime;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新时间", example = "2023-07-14 10:13:12", required = true)
    private Date updateTime;

    @ApiModelProperty(value = "子分类")
    private List<CategorySubDO> subDOList;


    @ApiModelProperty(value = "顺序")
    private Integer sort;

    public CategoryPrimaryDO(CategoryPrimaryVO primaryVO) {
        this.id = primaryVO.getId();
        this.name = primaryVO.getName();
        this.description = primaryVO.getDescription();
        this.icon = primaryVO.getIcon();
    }

    public CategoryPrimaryDTO buildCategoryPrimaryDTO() {
        return CategoryPrimaryDTO.builder()
                .id(this.id)
                .name(this.name)
                .description(this.description)
                .icon(this.icon)
                .createTime(this.createTime)
                .updateTime(this.updateTime)
                .subDTOList(this.subDOList)
                .sort(this.sort)
                .build();
    }


}
