package com.mmc.pms.entity;

import com.mmc.pms.model.lease.dto.WareImgDTO;
import com.mmc.pms.model.lease.vo.WareImgVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author small @Date 2023/5/16 10:01 @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class WareImgDO implements Serializable {
    private static final long serialVersionUID = -1711990559893951800L;
    private Integer id;
    private Integer wareInfoId;
    private String imgUrl;
    private Integer imgType;
    private Integer deleted;
    private Date createTime;

    public WareImgDTO buildWareImgDTO() {
        return WareImgDTO.builder()
                .id(this.id)
                .wareInfoId(this.wareInfoId)
                .imgType(this.imgType)
                .imgUrl(this.imgUrl)
                .build();
    }

    public WareImgDO(WareImgVO d) {
        this.id = d.getId();
        this.imgUrl = d.getImgUrl();
        this.imgType = d.getImgType();
    }
}
