package com.mmc.pms.entity;

import com.mmc.pms.model.sale.dto.ProductSkuDTO;
import com.mmc.pms.model.sale.dto.ProductSkuVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author small @Date 2023/5/16 16:29 @Version 1.0
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class ProductDO implements Serializable {
  private static final long serialVersionUID = -2830786012593215477L;
  private Integer id;
  private String productName;
  private String model;
  private Date createTime;
  private Date updateTime;
  private Integer brandInfoId;
  private Integer deleted;
  private Integer customize;
  private Integer type;

  /** 辅助字段 begin */
  private String brandName;

  /** 辅助字段 end */
  public ProductDO(ProductSkuVO param) {
    this.id = param.getId();
    this.model = param.getModel();
    this.productName = param.getProductName();
    this.brandInfoId = param.getProductBrandId();
    this.type = param.getType();
  }

  public ProductSkuDTO buildProductSkuDTO() {
    return ProductSkuDTO.builder()
        .id(this.id)
        .productName(this.productName)
        .model(this.model)
        .productBrand(this.brandName)
        .createTime(this.createTime)
        .productBrandId(brandInfoId)
        .type(this.type)
        .build();
  }
}
