package com.mmc.pms.dao;

import com.mmc.pms.entity.*;
import com.mmc.pms.model.lease.vo.LeaseVo;
import com.mmc.pms.model.qo.WareInfoQO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @Author small @Date 2023/5/15 14:35 @Version 1.0
 */
@Mapper
public interface WebDeviceDao {
  List<DistrictDO> listSecondDistrict();

  List<DeviceCategory> category();

  List<Brand> brand();

  List<Brand> deviceBrand();

  List<Model> model();

  List<Model> deviceModel();

  List<DeviceListDO> deviceList(
      Integer districtId, Integer categoryId, Integer brandId, Integer modelId);

  int update(LeaseVo param);

  InventoryDO findInventory(Integer inventoryId);

  List<WareInfoDO> detail(Integer id);

  int countListWareInfoPage(
      @Param("categoryIds") List<Integer> categoryIds,
      @Param("userIds") List<Integer> userIds,
      @Param("type") Integer type,
      @Param("goodsName")String goodsName);

  List<GoodsInfo> listWareInfoPage(
      @Param("param") WareInfoQO param,
      @Param("userIds") List<Integer> userIds,
      @Param("type") Integer type,
      @Param("goodsName")String goodsName);

  WareInfoDO getWareInfoById(Integer id);

  WareDetailDO getWareDetailById(Integer id);

  List<AdDO> ad();

  List<SkuInfoDO> listSkuInfo(Integer id);
}
