package com.mmc.pms.controller.inspection;

import com.mmc.pms.common.ResultBody;
import com.mmc.pms.model.inspection.dto.InspectionTagDTO;
import com.mmc.pms.model.inspection.vo.InspectionTagVO;
import com.mmc.pms.service.inspection.InspectionTagService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author: zj
 * @Date: 2023/8/4 15:33
 */
@Api(tags = {"服务标签"})
@RestController
@RequestMapping("/inspection-tag/")
public class InspectionTagController {
    @Autowired
    private InspectionTagService inspectionTagService;

    @ApiOperation(value = "新增服务标签")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("insert")
    public ResultBody insert(@RequestBody InspectionTagVO inspectionTagVO){
        return inspectionTagService.insert(inspectionTagVO);
    }

    @ApiOperation(value = "修改服务标签")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("update")
    public ResultBody update(@RequestBody InspectionTagVO inspectionTagVO){
        return inspectionTagService.update(inspectionTagVO);
    }

    @ApiOperation(value = "删除服务标签")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("delete")
    public ResultBody delete(@RequestParam Integer id){
        return inspectionTagService.delete(id);
    }

    @ApiOperation(value = "根据服务id查询标签列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("listByInspectionId")
    public ResultBody<InspectionTagDTO> listByInspectionId(@RequestParam Integer id){
        return inspectionTagService.listByInspectionId(id);
    }
}
