package com.mmc.pms.controller;

import com.mmc.pms.common.ResultBody;
import com.mmc.pms.model.group.Create;
import com.mmc.pms.model.group.Update;
import com.mmc.pms.model.qo.IndustrySkuQO;
import com.mmc.pms.model.sale.dto.*;
import com.mmc.pms.model.sale.vo.IndustrySkuVO;
import com.mmc.pms.model.sale.vo.IndustrySpecVO;
import com.mmc.pms.service.IndustrySpecService;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * @Author LW
 * @date 2022/10/8 10:57
 * 概要：
 */
@RestController
@RequestMapping("/industry/spec/")
@Api(tags = {"后台-行业管理-相关接口"})
public class BackstageIndustrySpecController {
    @Autowired
    IndustrySpecService industrySpecService;

    @ApiOperation(value = "新增行业sku")
    @PostMapping("addIndustrySku")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    public ResultBody addIndustrySku(@Validated(Create.class) @ApiParam("行业skuVO") @RequestBody IndustrySkuVO param) {
        return industrySpecService.addIndustrySku(param);
    }

    @ApiOperation(value = "行业sku详情")
    @GetMapping("getIndustrySkuDetail")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = IndustrySkuVO.class)})
    public ResultBody getIndustrySkuDetail(@ApiParam("id") @RequestParam(value = "id") Integer id) {
        return industrySpecService.getIndustrySkuDetail(id);
    }

    @ApiOperation(value = "行业sku管理---编辑行业sku")
    @PostMapping("editIndustrySku")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    public ResultBody editIndustrySku(@Validated(Update.class) @ApiParam("行业skuVO") @RequestBody IndustrySkuVO param) {
        return industrySpecService.editIndustrySku(param);
    }

    @ApiOperation(value = "行业sku管理---分页列表")
    @PostMapping("listPageIndustrySku")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = IndustrySkuDTO.class)})
    public ResultBody listPageIndustrySku(@ApiParam("条件参数") @RequestBody IndustrySkuQO param) {
        return industrySpecService.listPageIndustrySku(param);
    }

    @ApiOperation(value = "新增方案规格")
    @PostMapping("addIndustrySpec")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    public ResultBody addIndustrySpec(@Validated(Create.class) @ApiParam("条件参数") @RequestBody IndustrySpecVO param) {
        return industrySpecService.addIndustrySpec(param);
    }

    @ApiOperation(value = "方案规格回显")
    @GetMapping("getIndustrySpecDetail")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = IndustrySpecDTO.class)})
    public ResultBody getIndustrySpecDetail(@ApiParam("行业规格id") @RequestParam(value = "industrySpecId") Integer industrySpecId) {
        return industrySpecService.getIndustrySpecDetail(industrySpecId);
    }

    @ApiOperation(value = "编辑方案规格")
    @PostMapping("editIndustrySpec")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    public ResultBody editIndustrySpec(@Validated(Update.class) @ApiParam("行业skuVO") @RequestBody IndustrySpecVO param) {
        return industrySpecService.editIndustrySpec(param);
    }

    @ApiOperation(value = "行业sku管理---方案规格管理---分页列表")
    @GetMapping("listPageIndustrySpec")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = IndustrySpecDTO.class)})
    public ResultBody listPageIndustrySpec(@ApiParam(value = "页码") @RequestParam(value = "pageNo") Integer pageNo,
                                           @ApiParam(value = "每页显示数") @RequestParam(value = "pageSize") Integer pageSize,
                                           @ApiParam(value = "产品skuId") @RequestParam(value = "productSkuId") Integer industrySkuId,
                                           @ApiParam(value = "关键字") @RequestParam(value = "keyword", required = false) String keyword) {
        return industrySpecService.listPageIndustrySpec(pageNo, pageSize, industrySkuId, keyword);
    }

    @ApiOperation(value = "行业方案规格-价格配置")
    @PostMapping("industrySpecCPQ")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    public ResultBody industrySpecCPQ(@RequestBody IndustrySpecCPQVO industrySpecCPQQ) {
        return industrySpecService.industrySpecCPQ(industrySpecCPQQ);
    }

    @ApiOperation(value = "行业方案规格管理-价格配置信息的修改")
    @PostMapping("updateIndustrySpecCPQ")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    public ResultBody updateIndustrySpecCPQ(@RequestBody IndustrySpecCPQVO industrySpecCPQQ) {
        return industrySpecService.updateIndustrySpecCPQ(industrySpecCPQQ);
    }

    @ApiOperation(value = "行业sku管理---方案规格管理---获取价格配置信息")
    @PostMapping("getIndustrySpecCPQ")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = IndustrySpecPriceDTO.class)})
    public ResultBody getIndustrySpecCPQ(@RequestBody IndustrySpecCPQVO industrySpecCPQQ) {
        return industrySpecService.getIndustrySpecCPQ(industrySpecCPQQ);
    }

    @ApiOperation(value = "行业sku管理---删除行业sku")
    @GetMapping("removeIndustrySku")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    public ResultBody removeIndustrySku(@ApiParam("id") @RequestParam(value = "id") Integer id) {
        return industrySpecService.removeIndustrySku(id);
    }

    @ApiOperation(value = "行业sku管理---方案规格管理---删除行业规格")
    @GetMapping("removeIndustrySpec")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = RemoveSkuDTO.class)})
    public ResultBody removeIndustrySpec(@ApiParam("id") @RequestParam(value = "id") Integer id) {
        return industrySpecService.removeIndustrySpec(id);
    }
}