package com.mmc.pms.model.vo;

import com.mmc.pms.page.Page;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Author LW
 * @date 2023/5/25 11:25
 * 概要：
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class QueryClassifyVO implements Serializable {
    @ApiModelProperty(value = "所属目录id")
    @NotNull(message = "所属目录id不能为空", groups = {Update.class, Create.class})
    private Integer directoryId;

    @ApiModelProperty(value = "分类所属模块id(0：通用分类 1：作业服务分类 2：设备租赁分类 3：飞手培训分类 4：产品商城分类)")
    private Integer type;
    @ApiModelProperty(value = "页码", required = true)
    @NotNull(message = "页码不能为空", groups = {Page.class, Freeze.class})
    @Min(value = 1, groups = Page.class)
    private Integer pageNo;
    @ApiModelProperty(value = "每页显示数", required = true)
    @NotNull(message = "每页显示数不能为空", groups = {Page.class, Freeze.class})
    @Min(value = 1, groups = Page.class)
    private Integer pageSize;

    public void buildCurrentPage() {
        this.pageNo = (pageNo - 1) * pageSize;
    }

}
