package com.mmc.pms.entity;

import com.mmc.pms.model.dto.GoodsSpecDTO;
import com.mmc.pms.model.vo.GoodsSpecVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author small @Date 2023/5/16 15:26 @Version 1.0
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class MallProdSkuInfoDO implements Serializable {
    private static final long serialVersionUID = 3667714765929443857L;
    private Integer id;
    private Integer goodsInfoId;
    private Integer prodSkuId;
    private String prodSkuSpecName;
    private Integer categoryId;
    private Integer chooseType;
    private Integer must;
    private Integer skuUnitId;
    private Integer deleted;
    private Date createTime;
    private Date updateTime;
    private Integer flag;
    private String productSpecIdList;
    private String beforeUpdateSpec;
    /**
     * 辅助字段 start
     */
    private String typeName;

    private String unitName;
    private String productSkuName;
    private Integer brandInfoId;

    /**
     * 辅助字段 end
     */
    public MallProdSkuInfoDO(GoodsSpecVO goodsSpecVO) {
        this.categoryId = goodsSpecVO.getGoodsTypeId();
        this.prodSkuSpecName = goodsSpecVO.getGoodsSpecName();
        this.chooseType = goodsSpecVO.getChooseType();
        this.skuUnitId = goodsSpecVO.getSkuUnitId();
        this.must = goodsSpecVO.getMust();
        this.flag = goodsSpecVO.getFlag();
    }

    public GoodsSpecDTO buildGoodsSpecDTO() {
        return GoodsSpecDTO.builder()
                .id(this.id)
                .goodsSpecName(this.prodSkuSpecName)
                .goodsTypeId(this.categoryId)
                .chooseType(this.chooseType)
                .skuUnitId(skuUnitId)
                .unitName(this.unitName)
                .skuId(this.prodSkuId)
                .typeName(this.typeName)
                .must(must)
                .skuName(this.productSkuName)
                .brandInfoId(brandInfoId)
                .flag(flag)
                .build();
    }
}
