package com.mmc.pms.entity;

import com.mmc.pms.model.dto.GoodsOtherServiceDTO;
import com.mmc.pms.model.dto.GoodsServiceDTO;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author small @Date 2023/5/16 15:25 @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class GoodsServiceDO implements Serializable {
  private static final long serialVersionUID = -2612831712612727210L;
  private Integer id;
  private Integer goodsInfoId;
  private Integer saleServiceId;
  private Date createTime;

  /** 辅助字段-start */
  private String serviceName;

  private String remark;
  /** 辅助字段-end */
  public GoodsServiceDTO buildGoodsServiceDTO() {
    return GoodsServiceDTO.builder()
        .id(this.id)
        .saleServiceId(this.saleServiceId)
        .goodsInfoId(goodsInfoId)
        .serviceName(serviceName)
        .remark(remark)
        .build();
  }

  public GoodsOtherServiceDTO buildGoodsOtherServiceDTO() {
    return GoodsOtherServiceDTO.builder()
        .id(this.id)
        .saleServiceId(this.saleServiceId)
        .serviceName(this.serviceName)
        .build();
  }
}
