package com.mmc.pms.service.Impl;

import com.mmc.pms.common.ResultBody;
import com.mmc.pms.dao.WebProductMallDao;
import com.mmc.pms.entity.AdDO;
import com.mmc.pms.entity.GoodsInfoDO;
import com.mmc.pms.entity.ProductCategory;
import com.mmc.pms.model.dto.AdDTO;
import com.mmc.pms.model.dto.GoodsInfoListDTO;
import com.mmc.pms.model.dto.ProductCategoryDTO;
import com.mmc.pms.model.qo.GoodsInfoQO;
import com.mmc.pms.page.PageResult;
import com.mmc.pms.service.WebProductMallService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @Author small @Date 2023/5/15 20:08 @Version 1.0
 */
@Service
public class WebProductMallServiceImpl implements WebProductMallService {

  @Autowired private WebProductMallDao webProductMallDao;

  @Override
  public ResultBody productCategory() {
    List<ProductCategory> category = webProductMallDao.productCategory();
    List<ProductCategoryDTO> collect =
        category.stream()
            .map(
                t -> {
                  return t.productCategoryDTO();
                })
            .collect(Collectors.toList());
    return ResultBody.success(collect);
  }

  @Override
  public ResultBody productParts() {
    List<ProductCategory> category = webProductMallDao.productParts();
    List<ProductCategoryDTO> collect =
        category.stream()
            .map(
                t -> {
                  return t.productCategoryDTO();
                })
            .collect(Collectors.toList());
    return ResultBody.success(collect);
  }

  @Override
  public ResultBody productQuality() {
    List<ProductCategory> category = webProductMallDao.productQuality();
    List<ProductCategoryDTO> collect =
        category.stream()
            .map(
                t -> {
                  return t.productCategoryDTO();
                })
            .collect(Collectors.toList());
    return ResultBody.success(collect);
  }

  @Override
  public PageResult listPageGoodsInfo(GoodsInfoQO param) {
    int count = webProductMallDao.countListGoodsInfo(param);
    if (count == 0) {
      return PageResult.buildPage(param.getPageNo(), param.getPageSize(), count);
    }
    Integer pageNo = param.getPageNo();
    param.buildCurrentPage();
    List<GoodsInfoDO> goodsInfo = webProductMallDao.listGoodsInfo(param);
    goodsInfo.stream()
        .forEach(
            t -> {
              Integer product = webProductMallDao.findProduct(t.getId());
              t.setIsCoupons(product);
            });
    List<GoodsInfoListDTO> pageList =
        goodsInfo.stream().map(GoodsInfoDO::buildGoodsInfoListDTO).collect(Collectors.toList());
    return PageResult.buildPage(pageNo, param.getPageSize(), count, pageList);
  }

    @Override
    public ResultBody<AdDTO> ad() {
        List<AdDO> ad = webProductMallDao.ad();
        List<AdDTO> collect =
                ad.stream()
                        .map(
                                t -> {
                                    return t.adDTO();
                                })
                        .collect(Collectors.toList());
        return ResultBody.success(collect);
    }
}
