package com.mmc.pms.model.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author LW
 * @date 2022/10/8 10:22
 * 概要：
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class IndustrySpecPriceDTO implements Serializable {
    private static final long serialVersionUID = 2319479581071699519L;
    @ApiModelProperty(value = "id")
    private Integer id;
    @ApiModelProperty(value = "规格id")
    private Integer industrySpecId;
    @ApiModelProperty(value = "等级标签id")
    private Integer cooperationTag;
    @ApiModelProperty(value = "价格")
    private BigDecimal price;
    @ApiModelProperty(value = "租赁期限 (0：1-7天，1：8-15天，2：16-30天，3：30天以上)")
    private Integer leaseTerm;
    @ApiModelProperty(value = "创建时间")
    private Date createTime;
}
