package com.mmc.pms.model.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Author LW
 * @date 2022/10/11 14:29
 * 概要：
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class IndustrySpecDTO implements Serializable {
    private static final long serialVersionUID = 5476956071052692714L;
    @ApiModelProperty(value = "id")
    private Integer id;
    @ApiModelProperty(value = "行业skuId")
    private Integer industrySkuId;
    @ApiModelProperty(value = "规格名称")
    private String specName;
    @ApiModelProperty(value = "规格图片")
    private String specImage;
    @ApiModelProperty(value = "产品清单")
    private List<ProductInventoryVO> productInventoryList;
    @ApiModelProperty(value = "创建时间")
    private Date createTime;
}
