package com.mmc.pms.model.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Author LW
 * @date 2022/3/22 15:50
 * 概要：一级分类信息DTO
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ClassifyInfoDTO implements Serializable {
    private static final long serialVersionUID = -1682216002629752311L;
    @ApiModelProperty(value = "分类id")
    private Integer id;

    @ApiModelProperty(value = "所属目录id")
    private Integer directoryId;

    @ApiModelProperty(value = "分类名称")
    private String classifyName;

    @ApiModelProperty(value = "pid:一级分类的pid是0 二级分类pid是一级分类id")
    private Integer pid;

    @ApiModelProperty(value = "描述")
    private String description;

    @ApiModelProperty(value = "icon图标")
    private String icon;

    @ApiModelProperty(value = "小程序底部备注")
    private String remark;

    @ApiModelProperty(value = "分类所属模块id(0：通用分类 1：作业服务分类 2：设备租赁分类 3：飞手培训分类 4：产品商城分类)")
    private Integer type;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "二级分类信息")
    private List<ClassifyInfoDTO> children;
}
