package com.mmc.pms.entity;

import com.mmc.pms.model.dto.OrderReceiptDTO;
import com.mmc.pms.model.vo.OrderReceiptVO;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author small @Date 2023/5/25 10:05 @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
public class OrderReceiptDO implements Serializable {
  private static final long serialVersionUID = 7590192330910329668L;
  private Integer id;
  private Integer orderInfoId;
  private Integer receiptMethod;
  private String takeName;
  private String takePhone;
  private String region;
  private String detailAddress;
  private String repoName;
  private String repoAddress;
  private String bookPhone;
  private String sendExCode;
  private String sendExNo;
  private String sendAddress;
  private Integer renMethod;
  private String renPhone;
  private String renName;
  private String renExCode;
  private String renExNo;
  private String renAddress;
  private String exName;

  private String renRepoName;
  private String renRepoAddr;
  private String renRepoPhone;

  private Date createTime;

  public OrderReceiptDO(OrderReceiptVO d) {
    this.orderInfoId = d.getOrderInfoId();
    this.receiptMethod = d.getReceiptMethod();
    this.takeName = d.getTakeName();
    this.takePhone = d.getTakePhone();
    this.region = d.getRegion();
    this.detailAddress = d.getDetailAddress();
    this.repoName = d.getRepoName();
    this.repoAddress = d.getRepoAddress();
    this.bookPhone = d.getBookPhone();
  }

  public OrderReceiptDTO buildOrderReceiptDTO() {
    return OrderReceiptDTO.builder()
        .id(this.id)
        .receiptMethod(this.receiptMethod)
        .takeName(this.takeName)
        .takePhone(this.takePhone)
        .region(this.region)
        .detailAddress(this.detailAddress)
        .repoName(this.repoName)
        .repoAddress(this.repoAddress)
        .bookPhone(this.bookPhone)
        .sendExCode(this.sendExCode)
        .sendExNo(this.sendExNo)
        .sendAddress(this.sendAddress)
        .renMethod(this.renMethod)
        .renPhone(this.renPhone)
        .renName(this.renName)
        .renExCode(this.renExCode)
        .renExNo(this.renExNo)
        .renAddress(this.renAddress)
        .renRepoName(this.renRepoName)
        .renRepoAddr(this.renRepoAddr)
        .renRepoPhone(this.renRepoPhone)
        .build();
  }
}
