package com.mmc.pms.dao;

import com.mmc.pms.entity.*;
import com.mmc.pms.model.dto.ProductSkuVO;
import com.mmc.pms.model.dto.ProductSpecVO;
import com.mmc.pms.model.qo.ProductSkuQO;
import com.mmc.pms.model.vo.PriceAcquisition;
import com.mmc.pms.model.vo.ProductSpecCPQVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;
import java.util.Set;

/**
 * @author 23214
 * @description 针对表【product_sku(产品sku表)】的数据库操作Mapper
 * @createDate 2023-05-25 14:55:56
 * @Entity com.mmc.pms.entity.ProductSku
 */
@Mapper
public interface ProductDao {

    int countSkuName(ProductSkuVO param);

    int insertProductSku(ProductSkuDO productSkuDO);

    int countSkuIsExist(Integer id);

    ProductSkuDO getProductSkuDetail(Integer id);

    int updateProductSku(ProductSkuDO productSkuDO);

    int countListPageProductSku(ProductSkuQO productSkuQO);

    List<ProductSkuDO> listPageProductSku(ProductSkuQO productSkuQO);

    int countSpecName(ProductSpecVO param);

    int insertProductSpec(ProductSpecDO productSpecDO);

    int updateProductSpec(ProductSpecDO productSpecDO);

    int countSpecIsExist(Integer id);

    ProductSpecDO getProductSpecDetail(Integer id);

    int countListPageProductSpec(Integer productSkuId);

    List<ProductSpecDO> listPageProductSpec(int i, Integer pageSize, Integer productSkuId);

    int batchInsertSpecPrice(List<ProductSpecPriceDO> list);


    void batchInsertLeaseSpecPrice(List<ProductSpecPriceDO> list);

    void removeProductSpecCPQ(ProductSpecCPQVO productSpecCPQVO);

    List<ProductSpecPriceDO> getProductSpecPrice(ProductSpecCPQVO productSpecCPQVO);

    void insertMallProdSkuInfo(MallProdInfoDO mallProdInfoDO);

    List<ProductSpecDO> listProductSpec(Integer id);

    List<ProductSkuDO> listProductSkuDO(List<Integer> productSkuId);

    List<InventorySpecDO> listInventorySpecInfo(List<Integer> industryProductInventoryIds);

    List<ProductSpecDO> listProductSpecInfo(List<Integer> productSpecIds);

    void batchUpdateMallProdSpec(List<Integer> delProductSpecId);

    int countProductSpecByBrandId(Integer id);

    int countSpecByProdSkuId(Integer id);

    void removeProductSku(Integer id);

    List<MallProdInfoDO> listMallProdInfo(String id);

    void removeProductSpec(Integer id);

    List<IndustrySpecDO> listIndustrySpec(@Param("industrySpecIds") Set<Integer> industrySpecIds);

    List<InventorySpecDO> listInventorySpec(Integer id);

    BigDecimal feignGetUnitPriceByTag(PriceAcquisition priceAcquisition);

}




