package com.mmc.pms.controller;

import com.mmc.pms.common.ResultBody;
import com.mmc.pms.model.dto.MallGoodsDetailDTO;
import com.mmc.pms.model.dto.SkuUnitDTO;
import com.mmc.pms.model.vo.Create;
import com.mmc.pms.model.vo.GoodsAddVO;
import com.mmc.pms.model.vo.Update;
import com.mmc.pms.service.GoodsInfoService;
import io.swagger.annotations.*;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * @Author LW
 * @date 2023/3/14 13:22
 * 概要：
 */
@RestController
@RequestMapping("/goods")
@Api(tags = {"后台-商品管理-相关接口"})
public class BackstageGoodsManageController {
    @Resource
    private GoodsInfoService goodsInfoService;

    @ApiOperation(value = "新增(租赁/销售)商品")
    @PostMapping("addGoodsInfo")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    public ResultBody addGoods(@ApiParam("商品信息VO") @Validated(Create.class) @RequestBody GoodsAddVO goodsAddVO) {
        return goodsInfoService.addGoods(goodsAddVO);
    }

    @ApiOperation(value = "修改(租赁/销售)商品")
    @PostMapping("editGoodsInfo")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    public ResultBody editGoodsInfo(@ApiParam("商品信息VO") @Validated(Update.class) @RequestBody GoodsAddVO goodsAddVO) {
        return goodsInfoService.editGoodsInfo(goodsAddVO);
    }

    @ApiOperation(value = "PC端-商品详情")
    @GetMapping("getGoodsInfoDetail")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = MallGoodsDetailDTO.class)})
    public ResultBody getGoodsInfoDetail(@ApiParam("商品id") @RequestParam Integer goodsInfoId) {
        return goodsInfoService.getGoodsInfoDetail(goodsInfoId);
    }

    @ApiOperation(value = "单位信息")
    @GetMapping("getSkuUnit")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = SkuUnitDTO.class)})
    public ResultBody getSkuUnit() {
        return goodsInfoService.getSkuUnit();
    }
}
