package com.mmc.pms.dao.mall;

import com.mmc.pms.entity.mall.*;
import com.mmc.pms.model.mall.MallGoodsVO;
import com.mmc.pms.model.mall.SpecAttrVO;
import com.mmc.pms.model.sale.qo.MallGoodsInfoQO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @Author LW
 * @date 2023/7/24 17:38 概要：
 */
@Mapper
public interface MallGoodsDao {
    int countMallGoodsByName(@Param("mallGoodsVO") MallGoodsVO mallGoodsVO, @Param("userAccountId") Integer userAccountId);

    int countMallGoods(Integer userAccountId);

    void insertMallGoodsBaseInfo(MallGoodsDO mallGoodsDO);

    void batchInsertMallGoodsResources(List<MallGoodsResourcesDO> mallGoodsResourcesList);

    MallGoodsDO getMallGoodsBaseInfo(Integer id);

    List<MallGoodsResourcesDO> getMallGoodsResources(Integer id);

    void updateMallGoods(@Param("mallGoodsDO") MallGoodsDO mallGoodsDO);

    void deleteMallGoodsResources(Integer id);

    int countListMallGoods(MallGoodsInfoQO param);

    List<MallGoodsDO> listMallGoods(MallGoodsInfoQO param);

    int updateMallGoodsSort(Integer id, Integer sort);

    void updateMallGoodsByShelf(Integer id, Integer status);

    void removeMallGoods(Integer id);

    void feignRemoveGoodsByBackUserAccountId(Integer id);

    void batchInsertSpecAttr(List<SpecAttrValueDO> list);

    void batchInsertPriceStock(List<PriceStockDO> list);

    List<SpecAttrDO> listSpecAttr(Integer id);

    List<PriceStockDO> listPriceStock(Integer id);

    void insertSpecAttr(SpecAttrDO specAttrDO);

    List<SpecAttrValueDO> listSpecAttrValue(List<Integer> specIds);

    void deleteMallPriceStock(Integer id);

    void deleteSpecAttr(List<Integer> delIds);

    void updateSpecAttr(SpecAttrVO specAttrVO);

    void deleteSpecAttrValue(List<Integer> delValueIds);

    void updateSpecAttrValue(SpecAttrVO attrVO);

    int getMallGoodsCount();
}
