package com.mmc.pms.model.work.dto;

import com.mmc.pms.entity.InspComtDO;
import com.mmc.pms.entity.ServiceDO;
import com.mmc.pms.model.work.vo.ServiceVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Author LW
 * @date 2023/6/8 10:33
 * 概要：
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ServiceDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    private Integer id;

    @ApiModelProperty(value = "服务名称")
    private String serviceName;

    @ApiModelProperty(value = "应用")
    private Integer applicationId;

    @ApiModelProperty(value = "应用名称")
    private String applicationName;

    @ApiModelProperty(value = "行业")
    private Integer industryId;

    @ApiModelProperty(value = "行业名称")
    private String industryName;

    @ApiModelProperty(value = "展示状态")
    private Integer displayState;

    @ApiModelProperty(value = "封面图")
    private String coverPlan;

    @ApiModelProperty(value = "分享卡片")
    private String shareCard;

    @ApiModelProperty(value = "视频")
    private String video;

    @ApiModelProperty(value = "服务介绍")
    private String serviceIntroduction;

    @ApiModelProperty(value = "账号id")
    private Integer accountId;

    @ApiModelProperty(value = "评论列表")
    private List<InspComtDO> inspComtList;

    @ApiModelProperty(value = "评论数量")
    private Integer inspComtAmount;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "修改时间")
    private Date updateTime;

    @ApiModelProperty(value = "单位id")
    private Integer companyId;

    @ApiModelProperty(value = "单位名称")
    private String companyName;

    public ServiceDTO(ServiceVO param, Integer accountId) {
        this.id = param.getId();
        this.serviceName = param.getServiceName();
        this.applicationId = param.getApplicationId();
        this.industryId = param.getIndustryId();
        this.displayState = param.getDisplayState();
        this.coverPlan = param.getCoverPlan();
        this.shareCard = param.getShareCard();
        this.video = param.getVideo();
        this.serviceIntroduction = param.getServiceIntroduction();
        this.accountId = accountId;
    }

    public ServiceDTO(ServiceVO param) {
        this.id = param.getId();
        this.serviceName = param.getServiceName();
        this.applicationId = param.getApplicationId();
        this.industryId = param.getIndustryId();
        this.displayState = param.getDisplayState();
        this.coverPlan = param.getCoverPlan();
        this.shareCard = param.getShareCard();
        this.video = param.getVideo();
        this.serviceIntroduction = param.getServiceIntroduction();
    }

    public ServiceDTO(Integer id, Integer accountId) {
        this.id = id;
        this.accountId = accountId;
    }

    public ServiceDTO(ServiceDO serviceDO) {
        this.id = serviceDO.getId();
        this.serviceName = serviceDO.getServiceName();
        this.applicationId = serviceDO.getApplicationId();
        this.industryId = serviceDO.getIndustryId();
        this.displayState = serviceDO.getDisplayState();
        this.coverPlan = serviceDO.getCoverPlan();
        this.shareCard = serviceDO.getShareCard();
        this.video = serviceDO.getVideo();
        this.serviceIntroduction = serviceDO.getServiceIntroduction();
        this.accountId = serviceDO.getAccountId();
        this.createTime = serviceDO.getCreateTime();
        this.updateTime = serviceDO.getUpdateTime();
        this.companyId=serviceDO.getCompanyId();
    }

    public ServiceDTO(ServiceDO serviceDO,String companyName) {
        this.id = serviceDO.getId();
        this.serviceName = serviceDO.getServiceName();
        this.applicationId = serviceDO.getApplicationId();
        this.industryId = serviceDO.getIndustryId();
        this.displayState = serviceDO.getDisplayState();
        this.coverPlan = serviceDO.getCoverPlan();
        this.shareCard = serviceDO.getShareCard();
        this.video = serviceDO.getVideo();
        this.serviceIntroduction = serviceDO.getServiceIntroduction();
        this.accountId = serviceDO.getAccountId();
        this.createTime = serviceDO.getCreateTime();
        this.updateTime = serviceDO.getUpdateTime();
        this.companyId=serviceDO.getCompanyId();
        this.companyName=companyName;
    }

}
