package com.mmc.pms.entity;

import com.mmc.pms.model.work.vo.ServiceVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author LW
 *
 * @date 2023/6/8 10:33 概要：
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ServiceDO implements Serializable {

  private static final long serialVersionUID = 1L;

  private Integer id;

  @ApiModelProperty(value = "服务名称")
  private String serviceName;

  @ApiModelProperty(value = "应用")
  private Integer applicationId;

  @ApiModelProperty(value = "行业")
  private Integer industryId;

  @ApiModelProperty(value = "展示状态")
  private Integer displayState;

  @ApiModelProperty(value = "封面图")
  private String coverPlan;

  @ApiModelProperty(value = "分享卡片")
  private String shareCard;

  @ApiModelProperty(value = "视频")
  private String video;

  @ApiModelProperty(value = "服务介绍")
  private String serviceIntroduction;

  @ApiModelProperty(value = "创建人id")
  private Integer accountId;

  @ApiModelProperty(value = "创建时间")
  private Date createTime;

  @ApiModelProperty(value = "修改时间")
  private Date updateTime;

  @ApiModelProperty(value = "逻辑删除字段")
  private Integer isDeleted;

  @ApiModelProperty(value = "单位id")
  private Integer companyId;


  public ServiceDO(ServiceVO param, Integer accountId) {
    this(param);
    this.accountId = accountId;
  }

  public ServiceDO(ServiceVO param) {
    this.id = param.getId();
    this.serviceName = param.getServiceName();
    this.applicationId = param.getApplicationId();
    this.industryId = param.getIndustryId();
    this.displayState = param.getDisplayState();
    this.coverPlan = param.getCoverPlan();
    this.shareCard = param.getShareCard();
    this.video = param.getVideo();
    this.serviceIntroduction = param.getServiceIntroduction();
    this.companyId=param.getCompanyId();
  }

  public ServiceDO(Integer id, Integer accountId) {
    this.id = id;
    this.accountId = accountId;
  }
}
