package com.mmc.pms.controller;

import com.mmc.pms.common.Page;
import com.mmc.pms.common.ResultBody;
import com.mmc.pms.model.qo.ServiceQO;
import com.mmc.pms.model.work.dto.WorkServiceDTO;
import com.mmc.pms.service.BackstageTaskService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

@Api(tags = {"web-服务管理-模块"})
@RestController
@RequestMapping("/backstage/work")
public class WebTaskServiceController extends BaseController {

    @Resource
    private BackstageTaskService backstageTaskService;

    @ApiOperation(value = "web接口-条件查询作业服务列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = WorkServiceDTO.class)})
    @PostMapping("queryWorkServiceList")
    public ResultBody<WorkServiceDTO> queryWorkServiceList(@Validated(Page.class) @RequestBody ServiceQO param, HttpServletRequest request) {
        return ResultBody.success(backstageTaskService.queryWorkServiceList(param,request));
    }
}
