package com.mmc.pms.controller;

import com.mmc.pms.common.ResultBody;
import com.mmc.pms.model.categories.vo.DirectoryInfoVO;
import com.mmc.pms.model.group.Create;
import com.mmc.pms.model.group.Update;
import com.mmc.pms.model.lease.vo.PriceAcquisition;
import com.mmc.pms.model.qo.ProductSkuQO;
import com.mmc.pms.model.sale.dto.*;
import com.mmc.pms.model.sale.vo.ProductSpecCPQVO;
import com.mmc.pms.service.ProductSkuService;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;

/**
 * @Author LW
 *
 * @date 2022/9/22 10:28 概要：
 */
@RestController
@RequestMapping("/product/spec/")
@Api(tags = {"产品管理模块-相关接口"})
public class BackstageProductSpecController {
  @Autowired private ProductSkuService productSkuService;

  @ApiOperation(value = "新增产品")
  @PostMapping("addProductSku")
  @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
  public ResultBody addProductSku(
      @Validated(Create.class) @ApiParam("产品skuVO") @RequestBody ProductSkuVO param) {
    return productSkuService.addProductSku(param);
  }

  @ApiOperation(value = "产品详情")
  @GetMapping("getProductSkuDetail")
  @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ProductSkuDTO.class)})
  public ResultBody getProductSkuDetail(@ApiParam("id") @RequestParam(value = "id") Integer id) {
    return productSkuService.getProductSkuDetail(id);
  }

  @ApiOperation(value = "编辑产品")
  @PostMapping("editProductSku")
  @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
  public ResultBody editProductSku(
      @Validated(Update.class) @ApiParam("产品skuVO") @RequestBody ProductSkuVO param) {
    return productSkuService.editProductSku(param);
  }

  @ApiOperation(value = "产品目录列表")
  @GetMapping("productDirectoryList")
  @ApiResponses({@ApiResponse(code = 200, message = "OK", response = DirectoryInfoVO.class)})
  public ResultBody<DirectoryInfoVO> productDirectoryList() {
    return productSkuService.productDirectoryList();
  }

  @ApiOperation(value = "产品分页列表")
  @PostMapping("listPageProductSku")
  @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ProductSkuDTO.class)})
  public ResultBody listPageProductSku(@ApiParam("条件参数") @RequestBody ProductSkuQO productSkuQO) {
    return productSkuService.listPageProductSku(productSkuQO);
  }

  @ApiOperation(value = "删除产品sku")
  @GetMapping("removeProductSku")
  @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
  public ResultBody removeProductSku(@ApiParam("id") @RequestParam(value = "id") Integer id) {
    return productSkuService.removeProductSku(id);
  }

  @ApiOperation(value = "新增or修改产品规格")
  @PostMapping("addOrEditProductSpec")
  @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
  public ResultBody addOrEditProductSpec(
      @Validated({Create.class, Update.class}) @ApiParam("产品规格VO") @RequestBody
          ProductSpecVO param) {
    return productSkuService.addOrEditProductSpec(param);
  }

  @ApiOperation(value = "产品规格编辑回显")
  @GetMapping("getProductSpecDetail")
  @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ProductSpecDTO.class)})
  public ResultBody getProductSpecDetail(@ApiParam("id") @RequestParam(value = "id") Integer id) {
    return productSkuService.getProductSpecDetail(id);
  }

  @ApiOperation(value = "产品规格分页列表")
  @GetMapping("listPageProductSpec")
  @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ProductSpecDTO.class)})
  public ResultBody listPageProductSpec(
      @ApiParam(value = "页码") @RequestParam(value = "pageNo") Integer pageNo,
      @ApiParam(value = "每页显示数") @RequestParam(value = "pageSize") Integer pageSize,
      @ApiParam(value = "产品skuId") @RequestParam(value = "productSkuId") Integer productSkuId,
      @ApiParam(value = "关键字") @RequestParam(value = "keyword", required = false) String keyword) {
    return productSkuService.listPageProductSpec(pageNo, pageSize, productSkuId, keyword);
  }

  @ApiOperation(value = "产品规格管理-价格配置")
  @PostMapping("productSpecCPQ")
  @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
  public ResultBody productSpecCPQ(@RequestBody ProductSpecCPQVO productSpecCPQVO) {
    return productSkuService.productSpecCPQ(productSpecCPQVO);
  }

  @ApiOperation(value = "价格配置信息的修改")
  @PostMapping("updateProductSpecCPQ")
  @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
  public ResultBody updateProductSpecCPQ(@RequestBody ProductSpecCPQVO productSpecCPQVO) {
    return productSkuService.updateProductSpecCPQ(productSpecCPQVO);
  }

  @ApiOperation(value = "产品规格管理---获取价格配置信息")
  @PostMapping("getProductSpecCPQ")
  @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ProductSpecPriceDTO.class)})
  public ResultBody getProductSpecCPQ(@RequestBody ProductSpecCPQVO productSpecCPQVO) {
    return productSkuService.getProductSpecCPQ(productSpecCPQVO);
  }

  //
  //    @ApiOperation(value = "价格配置信息--恢复全局默认设置")
  //    @GetMapping("getDefaultSettings")
  //    @ApiResponses({@ApiResponse(code = 200, message = "OK", response =
  // ProductSpecPriceDTO.class)})
  //    public ResultBody getDefaultSettings(@ApiParam(value = "规格id") @RequestParam(value =
  // "productSpecId") Integer productSpecId) {
  //        return productSpecService.getDefaultSettings(productSpecId);
  //    }
  //
  @ApiOperation(value = "产品规格管理---删除规格")
  @GetMapping("removeProductSpec")
  @ApiResponses({@ApiResponse(code = 200, message = "OK", response = RemoveSkuDTO.class)})
  public ResultBody removeProductSpec(@ApiParam("id") @RequestParam(value = "id") Integer id) {
    return productSkuService.removeProductSpec(id);
  }
  //
  //    @ApiOperation(value = "feign根据渠道等级获取单价信息")
  //    @GetMapping("feignGetUnitPriceByTag")
  //    @ApiIgnore
  //    @ApiResponses({@ApiResponse(code = 200, message = "OK",response =
  // ProductSpecPriceDTO.class)})
  //    public ProductSpecPriceDTO feignGetUnitPriceByTag(@RequestParam(value = "specId")Integer
  // specId,
  //                                                      @RequestParam(value = "tagId")Integer
  // tagId) {
  //        return productSpecService.feignGetUnitPriceByTag(specId,tagId);
  //    }

  @ApiOperation(value = "feign根据渠道等级获取单价信息")
  @PostMapping("feignGetSpecLeaseUnitPrice")
  @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
  public BigDecimal feignGetUnitPriceByTag(@RequestBody PriceAcquisition priceAcquisition) {
    return productSkuService.feignGetUnitPriceByTag(priceAcquisition);
  }
}
