package com.mmc.pms.controller;

import com.mmc.pms.common.Page;
import com.mmc.pms.common.ResultBody;
import com.mmc.pms.model.group.Create;
import com.mmc.pms.model.group.Update;
import com.mmc.pms.model.qo.ServiceQO;
import com.mmc.pms.model.work.dto.ServiceDTO;
import com.mmc.pms.model.work.dto.WorkServiceDTO;
import com.mmc.pms.model.work.vo.ServiceVO;
import com.mmc.pms.model.work.vo.UpAndDownServiceVO;
import com.mmc.pms.service.BackstageTaskService;
import io.swagger.annotations.*;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @Author LW
 *
 * @date 2023/6/6 10:41 概要：
 */
@Api(tags = {"后台-服务管理-模块"})
@RestController
@RequestMapping("/backstage/work")
public class BackstageTaskServiceController extends BaseController {
  @Resource private BackstageTaskService backstageTaskService;

  @ApiOperation(value = "新增作业服务")
  @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
  @PostMapping("addWorkService")
  public ResultBody addWorkService(
      @Validated(Create.class) @RequestBody ServiceVO param, HttpServletRequest request) {
    return backstageTaskService.addWorkService(
        param, this.getUserLoginInfoFromRedis(request).getUserAccountId());
  }

  @ApiOperation(value = "修改作业服务")
  @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
  @PostMapping("updateWorkService")
  public ResultBody updateWorkService(@Validated(Update.class) @RequestBody ServiceVO param) {
    return backstageTaskService.updateById(param);
  }

  @ApiOperation(value = "批量删除作业服务")
  @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
  @PostMapping("deleteWorkService")
  public ResultBody deleteWorkService(@ApiParam("作业服务id") @RequestBody List<Integer> ids) {
    return backstageTaskService.deleteByIds(ids);
  }

  @ApiOperation(value = "批量上下架作业服务")
  @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
  @PostMapping("batchUpAndDownWorkService")
  public ResultBody batchUpAndDownWorkService(@RequestBody UpAndDownServiceVO param) {
    return backstageTaskService.batchUpAndDownWorkService(param);
  }

  @ApiOperation(value = "查询作业服务")
  @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ServiceDTO.class)})
  @GetMapping("queryWorkService")
  public ResultBody<ServiceDTO> queryWorkService(@ApiParam("作业服务id") @RequestParam(value = "id") Integer id) {
    return backstageTaskService.queryById(id);
  }

  @ApiOperation(value = "查询服务管理列表")
  @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ServiceDTO.class)})
  @PostMapping("queryServiceManagerList")
  public ResultBody<ServiceDTO> queryServiceManagerList(
          @Validated(Page.class) @RequestBody ServiceQO param, HttpServletRequest request) {
    return ResultBody.success(backstageTaskService.queryServiceManagerList(param, this.getUserLoginInfoFromRedis(request).getUserAccountId()));
  }

  @ApiOperation(value = "web接口-条件查询作业服务列表")
  @ApiResponses({@ApiResponse(code = 200, message = "OK", response = WorkServiceDTO.class)})
  @PostMapping("queryWorkServiceList")
  public ResultBody<WorkServiceDTO> queryWorkServiceList(@Validated(Page.class) @RequestBody ServiceQO param, HttpServletRequest request) {
    return ResultBody.success(backstageTaskService.queryWorkServiceList(param,request));
  }

  @ApiOperation(value = "远程查询作业服务")
  @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ServiceDTO.class)})
  @PostMapping("feignQueryWorkServiceListById")
  @ApiIgnore
  public List<ServiceDTO> feignQueryWorkServiceListById(@RequestBody List<Integer> ids) {
    return backstageTaskService.feignQueryWorkServiceListById(ids);
  }
}
