package com.mmc.pms.service.Impl;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.mmc.pms.common.ResultBody;
import com.mmc.pms.dao.ServiceOrderProvinceCityDao;
import com.mmc.pms.dao.ServiceOrderTaskDao;
import com.mmc.pms.dao.ServiceOrderTaskImageDao;
import com.mmc.pms.entity.ServiceOrderProvinceCityDO;
import com.mmc.pms.entity.ServiceOrderTaskDO;
import com.mmc.pms.entity.ServiceOrderTaskImageDO;
import com.mmc.pms.model.work.vo.ServiceOrderTaskVO;
import com.mmc.pms.service.ServiceOrderTaskService;
import com.mmc.pms.util.CodeUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * <p>
 * 云享飞服务订单-主表 服务实现类
 * </p>
 *
 * @author Pika
 * @since 2023-06-10
 */
@Service
public class ServiceOrderTaskServiceImpl extends ServiceImpl<ServiceOrderTaskDao, ServiceOrderTaskDO> implements ServiceOrderTaskService {

    @Autowired private ServiceOrderTaskDao serviceOrderTaskDao;

    @Autowired private ServiceOrderProvinceCityDao serviceOrderProvinceCityDao;

    @Autowired private ServiceOrderTaskImageDao serviceOrderTaskImageDao;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ResultBody insertOrderTask(ServiceOrderTaskVO param, Integer userAccountId) {
        // 保存作业服务订单
        ServiceOrderTaskDO orderTaskDO = ServiceOrderTaskDO.builder().orderNo(CodeUtil.createOrderTaskNO()).orderName(param.getInspectionName())
                .inspectionId(param.getInspectionId()).inspectionName(param.getInspectionName()).taskDescription(param.getTaskDescription())
                .startTime(param.getStartTime()).endTime(param.getEndTime()).userAccountId(userAccountId).build();
        serviceOrderTaskDao.insert(orderTaskDO);

        // 保存作业服务地址信息
        ServiceOrderProvinceCityDO provinceCityDO = ServiceOrderProvinceCityDO.builder().serviceOrderTaskId(orderTaskDO.getId()).province(param.getProvince()).city(param.getCity())
                .address(param.getAddress()).lat(param.getLat()).lon(param.getLon()).build();
        serviceOrderProvinceCityDao.insert(provinceCityDO);

        // 保存作业服务图片
        List<String> images = param.getImages();
        if(CollectionUtils.isNotEmpty(images)){
            ServiceOrderTaskImageDO imageDO = ServiceOrderTaskImageDO.builder().orderTaskId(orderTaskDO.getId()).picture(StringUtils.join(",", images)).build();
            serviceOrderTaskImageDao.insert(imageDO);
        }
        return ResultBody.success();
    }
}
