package com.mmc.pms.model.work.vo;


import com.baomidou.mybatisplus.annotation.TableName;
import com.mmc.pms.model.group.Create;

import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 云享飞服务订单-主表
 * </p>
 *
 * @author Pika
 * @since 2023-06-10
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ServiceOrderTaskVO implements Serializable {

    private static final long serialVersionUID = -178678654L;

    @ApiModelProperty(value = "服务项ID",example = "1")
    @NotNull(message = "新增服务-id不能为空", groups = {Create.class})
    private Integer inspectionId;

    @ApiModelProperty(value = "服务名称")
    @NotBlank(message = "新增服务-名称不能为空", groups = {Create.class})
    private String inspectionName;

    @ApiModelProperty(value = "预计服务开始时间")
    @NotNull(message = "新增服务-预计服务开始时间不能为空", groups = {Create.class})
    private Date startTime;

    @ApiModelProperty(value = "预计服务结束时间")
    @NotNull(message = "新增服务-预计服务结束时间不能为空", groups = {Create.class})
    private Date endTime;

    @ApiModelProperty(value = "省份",example = "广东")
    @NotBlank(message = "新增服务-省份不能为空", groups = {Create.class})
    private String province;

    @ApiModelProperty(value = "市",example = "深圳")
    @NotBlank(message = "新增服务-市不能为空", groups = {Create.class})
    private String city;

    @ApiModelProperty(value = "详细地址",example = "西丽街道")
    @NotBlank(message = "新增服务-详细地址不能为空", groups = {Create.class})
    private String address;

    @ApiModelProperty(value = "经度",example = "117.257370")
    @NotNull(message = "新增服务-经度不能为空", groups = {Create.class})
    private BigDecimal lon;

    @ApiModelProperty(value = "纬度",example = "32.050774")
    @NotNull(message = "新增服务-纬度不能为空", groups = {Create.class})
    private BigDecimal lat;

    @ApiModelProperty(value = "任务描述")
    private String taskDescription;

    @ApiModelProperty(value = "图片")
    private List<String> images;
}
