package com.mmc.pms.model.order.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @Author small @Date 2023/5/25 9:45 @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
// @ApiModel(value = "com.mmc.csf.model.dto.OrderReceiptDTO", description = "订单收货信息DTO")
public class OrderReceiptDTO implements Serializable {
    private static final long serialVersionUID = -6212026509857770276L;

    @ApiModelProperty(value = "地址ID")
    private Integer id;

    @ApiModelProperty(value = "收货方式：0邮寄 1门店地址")
    private Integer receiptMethod;

    @ApiModelProperty(value = "0-收货人姓名")
    private String takeName;

    @ApiModelProperty(value = "0-收货人电话")
    private String takePhone;

    @ApiModelProperty(value = "0-收货区域")
    private String region;

    @ApiModelProperty(value = "0-收获详细地址")
    private String detailAddress;

    @ApiModelProperty(value = "1-门店名称")
    private String repoName;

    @ApiModelProperty(value = "1-门店详细地址")
    private String repoAddress;

    @ApiModelProperty(value = "1-预留手机号")
    private String bookPhone;

    @ApiModelProperty(value = "发货-物流公司码")
    private String sendExCode;

    @ApiModelProperty(value = "发货-物流单号")
    private String sendExNo;

    @ApiModelProperty(value = "发货地址")
    private String sendAddress;

    @ApiModelProperty(value = "退还货方式：0邮寄 1门店地址")
    private Integer renMethod;

    @ApiModelProperty(value = "退还货-收货电话")
    private String renPhone;

    @ApiModelProperty(value = "退还货-收货人")
    private String renName;

    @ApiModelProperty(value = "退还货-物流公司码")
    private String renExCode;

    @ApiModelProperty(value = "退还货-物流单号")
    private String renExNo;

    @ApiModelProperty(value = "退还货-地址")
    private String renAddress;

    @ApiModelProperty(value = "退还货-门店名称")
    private String renRepoName;

    @ApiModelProperty(value = "退还货-门店地址")
    private String renRepoAddr;

    @ApiModelProperty(value = "退还货-门店联系电话")
    private String renRepoPhone;
}
