package com.mmc.pms.entity;

import com.mmc.pms.model.sale.dto.GoodsSpecDTO;
import com.mmc.pms.model.sale.vo.GoodsProdSpecVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author small @Date 2023/5/16 15:33 @Version 1.0
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class MallIndustrySkuInfoDO implements Serializable {
    private static final long serialVersionUID = 1492322282696261487L;
    private Integer id;
    private Integer goodsInfoId;
    private Integer industrySkuId;
    private String industrySkuSpecName;
    private Integer categoriesId;
    private Integer chooseType;
    private Integer must;
    private Integer skuUnitId;
    private Integer deleted;
    private Date createTime;
    private Date updateTime;

    /**
     * 辅助字段start
     */
    private String typeName;

    private String unitName;
    private String industrySkuName;

    /**
     * 辅助字段end
     */
    public MallIndustrySkuInfoDO(GoodsProdSpecVO goodsSpecVO) {
        this.industrySkuId = goodsSpecVO.getSkuId();
        this.chooseType = goodsSpecVO.getChooseType();
        this.industrySkuSpecName = goodsSpecVO.getGoodsSpecName();
        this.skuUnitId = goodsSpecVO.getSkuUnitId();
        this.categoriesId = goodsSpecVO.getCategoryId();
        this.must = goodsSpecVO.getMust();
    }

    public GoodsSpecDTO buildGoodsSpecDTO() {
        return GoodsSpecDTO.builder()
                .id(this.id)
                .goodsSpecName(this.industrySkuSpecName)
                .categoryId(this.categoriesId)
                .chooseType(this.chooseType)
                .skuUnitId(skuUnitId)
                .unitName(this.unitName)
                .skuId(this.industrySkuId)
                .typeName(this.typeName)
                .skuName(this.industrySkuName)
                .must(must)
                .build();
    }
}
